/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJB;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.ejb.api.DeploymentServiceEJBLocal;
import org.jbpm.services.ejb.api.ProcessServiceEJBLocal;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBLocal;
import org.jbpm.services.ejb.test.AbstractTestSupport;
import org.jbpm.test.listener.NodeLeftCountDownProcessEventListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.scanner.KieMavenRepository;

@RunWith(value=Arquillian.class)
public class AsyncExecutionProcessServiceEJBIntegrationTest
extends AbstractTestSupport {
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    @EJB
    private DeploymentServiceEJBLocal deploymentService;
    @EJB
    private ProcessServiceEJBLocal processService;
    @EJB
    private RuntimeDataServiceEJBLocal runtimeDataService;

    @Deployment
    public static WebArchive createDeployment() {
        File archive = new File("target/sample-war-ejb-app.war");
        if (!archive.exists()) {
            throw new IllegalStateException("There is no archive yet generated, run maven build or mvn assembly:assembly");
        }
        WebArchive war = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)archive);
        war.addPackage("org.jbpm.services.ejb.test");
        war.addClass("org.jbpm.test.listener.NodeLeftCountDownProcessEventListener");
        AsyncExecutionProcessServiceEJBIntegrationTest.deployKjar();
        return war;
    }

    protected static void deployKjar() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("processes/async-execution.bpmn2");
        InternalKieModule kJar1 = AsyncExecutionProcessServiceEJBIntegrationTest.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(AsyncExecutionProcessServiceEJBIntegrationTest.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        AsyncExecutionProcessServiceEJBIntegrationTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
    }

    @Test
    public void testStartProcessWithParms() throws Exception {
        Assert.assertNotNull((Object)this.deploymentService);
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Task 1", 1);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        this.processService.execute(deploymentUnit.getIdentifier(), (Command)new ExecutableCommand<Void>(){
            private static final long serialVersionUID = -5416366832158798895L;

            public Void execute(Context context) {
                KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                ksession.addEventListener((ProcessEventListener)countDownListener);
                return null;
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("command", "org.jbpm.executor.commands.PrintOutCommand");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "AsyncExecution", params);
        Assert.assertNotNull((Object)processInstanceId);
        countDownListener.waitTillCompleted(10000L);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }
}

