/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJB;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jbpm.kie.services.impl.DeployedUnitImpl;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.store.DeploymentStore;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.ejb.api.DeploymentServiceEJBLocal;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBLocal;
import org.jbpm.services.ejb.impl.tx.TransactionalCommandServiceEJBImpl;
import org.jbpm.services.ejb.test.AbstractTestSupport;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.scanner.KieMavenRepository;

@RunWith(value=Arquillian.class)
public class DeploymentServiceEJBIntegrationTest
extends AbstractTestSupport {
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    @EJB
    private RuntimeDataServiceEJBLocal runtimeDataService;
    @EJB
    private DeploymentServiceEJBLocal deploymentService;
    @EJB(beanInterface=TransactionalCommandServiceEJBImpl.class)
    private TransactionalCommandService commandService;

    @After
    public void cleanup() {
        DeploymentServiceEJBIntegrationTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
    }

    @Deployment
    public static WebArchive createDeployment() {
        File archive = new File("target/sample-war-ejb-app.war");
        if (!archive.exists()) {
            throw new IllegalStateException("There is no archive yet generated, run maven build or mvn assembly:assembly");
        }
        WebArchive war = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)archive);
        war.addPackage("org.jbpm.services.ejb.test");
        DeploymentServiceEJBIntegrationTest.deployKjar();
        return war;
    }

    protected static void deployKjar() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("processes/customtask.bpmn");
        processes.add("processes/humanTask.bpmn");
        processes.add("processes/signal.bpmn");
        processes.add("processes/import.bpmn");
        processes.add("processes/callactivity.bpmn");
        InternalKieModule kJar1 = DeploymentServiceEJBIntegrationTest.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(DeploymentServiceEJBIntegrationTest.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
        ReleaseId releaseIdSupport = ks.newReleaseId("org.jbpm.test", "support", "1.0.0-SNAPSHOT");
        ArrayList<String> processesSupport = new ArrayList<String>();
        processesSupport.add("processes/support.bpmn");
        InternalKieModule kJar2 = DeploymentServiceEJBIntegrationTest.createKieJar(ks, releaseIdSupport, processesSupport);
        File pom2 = new File("target/kmodule2", "pom.xml");
        pom2.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom2);
            fs.write(DeploymentServiceEJBIntegrationTest.getPom(releaseIdSupport, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        repository.installArtifact((AFReleaseId)releaseIdSupport, kJar2, pom2);
        ReleaseId releaseId3 = ks.newReleaseId("org.jbpm.test", "test-module", "1.1.0-SNAPSHOT");
        InternalKieModule kJar3 = DeploymentServiceEJBIntegrationTest.createKieJar(ks, releaseId3, processes);
        File pom3 = new File("target/kmodule3", "pom.xml");
        pom3.getParentFile().mkdirs();
        try {
            FileOutputStream fs = new FileOutputStream(pom3);
            fs.write(DeploymentServiceEJBIntegrationTest.getPom(releaseId3, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId3, kJar3, pom3);
    }

    @Test
    public void testDeploymentOfProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)5L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByFilter("custom", new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByDeploymentId(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)5L, (long)processes.size());
        ProcessDefinition process = this.runtimeDataService.getProcessesByDeploymentIdProcessId(deploymentUnit.getIdentifier(), "customtask");
        Assert.assertNotNull((Object)process);
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        ProcessInstance processInstance = engine.getKieSession().startProcess("customtask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testDeploymentOfAllProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnitGeneral = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnitGeneral);
        this.units.add((DeploymentUnit)deploymentUnitGeneral);
        RuntimeManager managerGeneral = this.deploymentService.getRuntimeManager(deploymentUnitGeneral.getIdentifier());
        Assert.assertNotNull((Object)managerGeneral);
        KModuleDeploymentUnit deploymentUnitSupport = new KModuleDeploymentUnit("org.jbpm.test", "support", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnitSupport);
        this.units.add((DeploymentUnit)deploymentUnitSupport);
        DeployedUnit deployedGeneral = this.deploymentService.getDeployedUnit(deploymentUnitGeneral.getIdentifier());
        Assert.assertNotNull((Object)deployedGeneral);
        Assert.assertNotNull((Object)deployedGeneral.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedGeneral.getRuntimeManager());
        RuntimeManager managerSupport = this.deploymentService.getRuntimeManager(deploymentUnitSupport.getIdentifier());
        Assert.assertNotNull((Object)managerSupport);
        DeployedUnit deployedSupport = this.deploymentService.getDeployedUnit(deploymentUnitSupport.getIdentifier());
        Assert.assertNotNull((Object)deployedSupport);
        Assert.assertNotNull((Object)deployedSupport.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedSupport.getRuntimeManager());
        RuntimeEngine engine = managerGeneral.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        ProcessInstance processInstance = engine.getKieSession().startProcess("customtask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        RuntimeEngine engineSupport = managerSupport.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engineSupport);
        ProcessInstance supportPI = engineSupport.getKieSession().startProcess("support.process");
        Assert.assertEquals((long)1L, (long)supportPI.getState());
        List tasks = engineSupport.getTaskService().getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        engineSupport.getKieSession().abortProcessInstance(supportPI.getId());
        Assert.assertNull((Object)engineSupport.getKieSession().getProcessInstance((long)supportPI.getState()));
    }

    @Test
    public void testDuplicatedDeployment() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployedGeneral = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployedGeneral);
        Assert.assertNotNull((Object)deployedGeneral.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedGeneral.getRuntimeManager());
        try {
            this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("Unit with id org.jbpm.test:test-module:1.0.0-SNAPSHOT is already deployed"));
        }
    }

    @Test
    public void testDeploymentOfMultipleVersions() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        KModuleDeploymentUnit deploymentUnit3 = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.1.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit3);
        this.units.add((DeploymentUnit)deploymentUnit3);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertEquals((long)0L, (long)((DeployedUnitImpl)deployed).getDeployedClasses().size());
        DeployedUnit deployed3 = this.deploymentService.getDeployedUnit(deploymentUnit3.getIdentifier());
        Assert.assertNotNull((Object)deployed3);
        Assert.assertNotNull((Object)deployed3.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed3.getRuntimeManager());
        Assert.assertEquals((long)0L, (long)((DeployedUnitImpl)deployed3).getDeployedClasses().size());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)10L, (long)processes.size());
        DeployedUnit deployedLatest = this.deploymentService.getDeployedUnit("org.jbpm.test:test-module:LATEST");
        Assert.assertNotNull((Object)deployedLatest);
        Assert.assertNotNull((Object)deployedLatest.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedLatest.getRuntimeManager());
        Assert.assertEquals((Object)deploymentUnit3.getIdentifier(), (Object)deployedLatest.getDeploymentUnit().getIdentifier());
    }

    @Test
    public void testDeploymentOfProcessesWithActivation() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertTrue((boolean)deployed.isActive());
        Assert.assertEquals((long)0L, (long)((DeployedUnitImpl)deployed).getDeployedClasses().size());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)5L, (long)processes.size());
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        this.deploymentService.deactivate(deploymentUnit.getIdentifier());
        deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertFalse((boolean)deployed.isActive());
        processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)0L, (long)processes.size());
        this.deploymentService.activate(deploymentUnit.getIdentifier());
        deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertTrue((boolean)deployed.isActive());
        processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)5L, (long)processes.size());
    }

    @Test
    public void testDeploymentOfProcessesVerifyTransientObjectOmitted() {
        Assert.assertNotNull((Object)this.deploymentService);
        Assert.assertNotNull((Object)this.commandService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)5L, (long)processes.size());
        DeploymentStore store = new DeploymentStore();
        store.setCommandService(this.commandService);
        Collection units = store.getEnabledDeploymentUnits();
        Assert.assertNotNull((Object)units);
        Assert.assertEquals((long)1L, (long)units.size());
        DeploymentUnit enabled = (DeploymentUnit)units.iterator().next();
        Assert.assertNotNull((Object)enabled);
        Assert.assertTrue((boolean)(enabled instanceof KModuleDeploymentUnit));
        KModuleDeploymentUnit kmoduleEnabled = (KModuleDeploymentUnit)enabled;
        DeploymentDescriptor dd = kmoduleEnabled.getDeploymentDescriptor();
        Assert.assertNotNull((Object)dd);
        Assert.assertEquals((long)0L, (long)dd.getWorkItemHandlers().size());
    }
}

