/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.test;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJB;
import javax.inject.Inject;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.query.SqlQueryDefinition;
import org.jbpm.kie.services.impl.query.mapper.ProcessInstanceQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.ProcessInstanceWithVarsQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.UserTaskInstanceQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.UserTaskInstanceWithVarsQueryMapper;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceWithVarsDesc;
import org.jbpm.services.api.model.UserTaskInstanceWithVarsDesc;
import org.jbpm.services.api.query.NamedQueryMapper;
import org.jbpm.services.api.query.QueryNotFoundException;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.jbpm.services.api.query.model.QueryParam;
import org.jbpm.services.ejb.api.DeploymentServiceEJBLocal;
import org.jbpm.services.ejb.api.ProcessServiceEJBLocal;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBLocal;
import org.jbpm.services.ejb.api.query.QueryServiceEJBLocal;
import org.jbpm.services.ejb.impl.tx.TransactionalCommandServiceEJBImpl;
import org.jbpm.services.ejb.test.AbstractTestSupport;
import org.jbpm.services.ejb.test.identity.TestIdentityProvider;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.UpdateStringCommand;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Arquillian.class)
public class QueryServiceEJBIntegrationTest
extends AbstractTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(QueryServiceEJBIntegrationTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    protected String correctUser = "testUser";
    protected String wrongUser = "wrongUser";
    private Long processInstanceId = null;
    private static KModuleDeploymentUnit deploymentUnit = null;
    private QueryDefinition query;
    @EJB
    private DeploymentServiceEJBLocal deploymentService;
    @EJB
    private ProcessServiceEJBLocal processService;
    @EJB
    private RuntimeDataServiceEJBLocal runtimeDataService;
    @EJB(beanInterface=TransactionalCommandServiceEJBImpl.class)
    private TransactionalCommandService commandService;
    @Inject
    private TestIdentityProvider identityProvider;
    @EJB
    private QueryServiceEJBLocal queryService;

    @Deployment
    public static WebArchive createDeployment() {
        File archive = new File("target/sample-war-ejb-app.war");
        if (!archive.exists()) {
            throw new IllegalStateException("There is no archive yet generated, run maven build or mvn assembly:assembly");
        }
        WebArchive war = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)archive);
        war.addPackage("org.jbpm.services.ejb.test");
        war.addPackage("org.jbpm.services.ejb.test.identity");
        QueryServiceEJBIntegrationTest.deployKjar();
        return war;
    }

    @Before
    public void prepare() {
        Assert.assertNotNull((Object)this.deploymentService);
        deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
    }

    protected static void deployKjar() {
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/EmptyHumanTask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/BPMN2-UserTask.bpmn2");
        processes.add("repo/processes/general/SimpleHTProcess.bpmn2");
        processes.add("repo/processes/general/AdHocSubProcess.bpmn2");
        InternalKieModule kJar1 = QueryServiceEJBIntegrationTest.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(QueryServiceEJBIntegrationTest.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        if (this.query != null) {
            try {
                this.queryService.unregisterQuery(this.query.getName());
            }
            catch (QueryNotFoundException queryNotFoundException) {
                // empty catch block
            }
        }
        if (this.processInstanceId != null) {
            this.processService.abortProcessInstance(this.processInstanceId);
            ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
            Assert.assertNull((Object)pi);
        }
        int deleted = 0;
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  NodeInstanceLog nid"))).intValue();
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  ProcessInstanceLog pid"))).intValue();
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  VariableInstanceLog vsd"))).intValue();
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  AuditTaskImpl vsd"))).intValue();
        System.out.println("Deleted " + (deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  TaskVariableImpl vsd"))).intValue()));
        QueryServiceEJBIntegrationTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
    }

    @Test
    public void testGetProcessInstances() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", "java:jboss/datasources/ExampleDS");
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)new NamedQueryMapper("ProcessInstances"), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext("PROCESSNAME", false), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByState() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", "java:jboss/datasources/ExampleDS");
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"STATUS", (Comparable[])new Comparable[]{Integer.valueOf(3)})});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"STATUS", (Comparable[])new Comparable[]{Integer.valueOf(3), Integer.valueOf(1)})});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"STATUS", (Comparable[])new Comparable[]{Integer.valueOf(3)})});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByProcessId() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", "java:jboss/datasources/ExampleDS");
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.likeTo((String)"PROCESSID", (boolean)true, (Comparable)((Object)"org.jbpm%"))});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesWithVariables() {
        this.query = new SqlQueryDefinition("getAllProcessInstancesWithVariables", "java:jboss/datasources/ExampleDS");
        this.query.setExpression("select pil.*, v.variableId, v.value from ProcessInstanceLog pil inner join (select vil.processInstanceId ,vil.variableId, MAX(vil.ID) maxvilid  FROM VariableInstanceLog vil GROUP BY vil.processInstanceId, vil.variableId ORDER BY vil.processInstanceId)  x ON (v.variableId = x.variableId  AND v.id = x.maxvilid )INNER JOIN VariableInstanceLog v ON (v.processInstanceId = pil.processInstanceId)");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        params.put("approval_translatedDocument", "translated content");
        params.put("approval_reviewComment", "reviewed content");
        this.processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        ProcessInstanceWithVarsDesc instance = (ProcessInstanceWithVarsDesc)processInstanceLogs.get(0);
        Assert.assertEquals((long)3L, (long)instance.getVariables().size());
        processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"VARIABLEID", (Comparable[])new Comparable[]{"approval_document"})});
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        instance = (ProcessInstanceWithVarsDesc)processInstanceLogs.get(0);
        Assert.assertEquals((long)1L, (long)instance.getVariables().size());
        processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"VARIABLEID", (Comparable[])new Comparable[]{"not existing"})});
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)0L, (long)processInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstances() {
        this.query = new SqlQueryDefinition("getAllTaskInstances", "java:jboss/datasources/ExampleDS");
        this.query.setExpression("select ti.* from AuditTaskImpl ti ");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesWithVariables() {
        this.query = new SqlQueryDefinition("getAllTaskInputInstancesWithVariables", "java:jboss/datasources/ExampleDS");
        this.query.setExpression("select ti.*, tv.name tvname, tv.value tvvalue from AuditTaskImpl ti inner join (select tv.taskId, tv.name, tv.value from TaskVariableImpl tv where tv.type = 0 ) tv on (tv.taskId = ti.taskId)");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        params.put("approval_translatedDocument", "translated content");
        params.put("approval_reviewComment", "reviewed content");
        this.processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        UserTaskInstanceWithVarsDesc instance = (UserTaskInstanceWithVarsDesc)taskInstanceLogs.get(0);
        Assert.assertEquals((long)5L, (long)instance.getVariables().size());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"TVNAME", (Comparable[])new Comparable[]{"Comment"}), QueryParam.equalsTo((String)"TVVALUE", (Comparable[])new Comparable[]{"Write a Document"})});
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        instance = (UserTaskInstanceWithVarsDesc)taskInstanceLogs.get(0);
        Assert.assertEquals((long)1L, (long)instance.getVariables().size());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"TVNAME", (Comparable[])new Comparable[]{"Comment"}), QueryParam.equalsTo((String)"TVVALUE", (Comparable[])new Comparable[]{"Wrong Comment"})});
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesAsPotOwners() {
        this.query = new SqlQueryDefinition("getMyTaskInstances", "java:jboss/datasources/ExampleDS", QueryDefinition.Target.PO_TASK);
        this.query.setExpression("select ti.*, oe.id OEID from AuditTaskImpl ti,PeopleAssignments_PotOwners po, OrganizationalEntity oe where ti.taskId = po.task_id and po.entity_id = oe.id ");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        this.identityProvider.setName("notvalid");
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("salaboy");
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesAsBA() {
        this.query = new SqlQueryDefinition("getBATaskInstances", "java:jboss/datasources/ExampleDS", QueryDefinition.Target.BA_TASK);
        this.query.setExpression("select ti.*, oe.id OEID from AuditTaskImpl ti,PeopleAssignments_BAs bas, OrganizationalEntity oe where ti.taskId = bas.task_id and bas.entity_id = oe.id ");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("Administrator");
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("salaboy");
        this.identityProvider.setRoles(Arrays.asList("Administrators"));
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    protected void setFieldValue(Object instance, String fieldName, Object value) {
        try {
            Field f = instance.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

