/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJB;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.model.VariableDesc;
import org.jbpm.services.ejb.api.DeploymentServiceEJBLocal;
import org.jbpm.services.ejb.api.ProcessServiceEJBLocal;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBLocal;
import org.jbpm.services.ejb.api.UserTaskServiceEJBLocal;
import org.jbpm.services.ejb.impl.tx.TransactionalCommandServiceEJBImpl;
import org.jbpm.services.ejb.test.AbstractTestSupport;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.UpdateStringCommand;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.api.model.TaskEvent;
import org.kie.scanner.KieMavenRepository;

@RunWith(value=Arquillian.class)
public class RuntimeDataServiceEJBIntegrationTest
extends AbstractTestSupport {
    private Long processInstanceId = null;
    private KModuleDeploymentUnit deploymentUnit = null;
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    @EJB
    private DeploymentServiceEJBLocal deploymentService;
    @EJB
    private ProcessServiceEJBLocal processService;
    @EJB
    private RuntimeDataServiceEJBLocal runtimeDataService;
    @EJB(beanInterface=TransactionalCommandServiceEJBImpl.class)
    private TransactionalCommandService commandService;
    @EJB
    private UserTaskServiceEJBLocal userTaskService;

    @Deployment
    public static WebArchive createDeployment() {
        File archive = new File("target/sample-war-ejb-app.war");
        if (!archive.exists()) {
            throw new IllegalStateException("There is no archive yet generated, run maven build or mvn assembly:assembly");
        }
        WebArchive war = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)archive);
        war.addPackage("org.jbpm.services.ejb.test");
        RuntimeDataServiceEJBIntegrationTest.deployKjar();
        return war;
    }

    @Before
    public void prepare() {
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
    }

    protected static void deployKjar() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("processes/EmptyHumanTask.bpmn");
        processes.add("processes/humanTask.bpmn");
        processes.add("processes/SimpleHTProcess.bpmn2");
        InternalKieModule kJar1 = RuntimeDataServiceEJBIntegrationTest.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(RuntimeDataServiceEJBIntegrationTest.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        if (this.processInstanceId != null) {
            this.processService.abortProcessInstance(this.processInstanceId);
            ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
            Assert.assertNull((Object)pi);
        }
        int deleted = 0;
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  NodeInstanceLog nid"))).intValue();
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  ProcessInstanceLog pid"))).intValue();
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  VariableInstanceLog vsd"))).intValue();
        System.out.println("Deleted " + (deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  AuditTaskImpl vsd"))).intValue()));
        RuntimeDataServiceEJBIntegrationTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
    }

    @Test
    public void testGetProcessByDeploymentId() {
        Collection definitions = this.runtimeDataService.getProcessesByDeploymentId(this.deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)definitions);
        Assert.assertEquals((long)3L, (long)definitions.size());
        ArrayList<String> expectedProcessIds = new ArrayList<String>();
        expectedProcessIds.add("org.jbpm.writedocument.empty");
        expectedProcessIds.add("org.jbpm.writedocument");
        expectedProcessIds.add("org.jboss.qa.bpms.HumanTask");
        for (ProcessDefinition def : definitions) {
            Assert.assertTrue((boolean)expectedProcessIds.contains(def.getId()));
        }
    }

    @Test
    public void testGetProcessByDeploymentIdAndProcessId() {
        ProcessDefinition definition = this.runtimeDataService.getProcessesByDeploymentIdProcessId(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)definition.getId());
    }

    @Test
    public void testGetProcessByFilter() {
        Collection definitions = this.runtimeDataService.getProcessesByFilter("org.jbpm", new QueryContext());
        Assert.assertNotNull((Object)definitions);
        Assert.assertEquals((long)2L, (long)definitions.size());
        ArrayList<String> expectedProcessIds = new ArrayList<String>();
        expectedProcessIds.add("org.jbpm.writedocument.empty");
        expectedProcessIds.add("org.jbpm.writedocument");
        for (ProcessDefinition def : definitions) {
            Assert.assertTrue((boolean)expectedProcessIds.contains(def.getId()));
        }
    }

    @Test
    public void testGetProcessByProcessId() {
        Collection definition = this.runtimeDataService.getProcessesById("org.jbpm.writedocument");
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((long)1L, (long)definition.size());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)((ProcessDefinition)definition.iterator().next()).getId());
    }

    @Test
    public void testGetProcesses() {
        Collection definitions = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)definitions);
        Assert.assertEquals((long)3L, (long)definitions.size());
        ArrayList<String> expectedProcessIds = new ArrayList<String>();
        expectedProcessIds.add("org.jbpm.writedocument.empty");
        expectedProcessIds.add("org.jbpm.writedocument");
        expectedProcessIds.add("org.jboss.qa.bpms.HumanTask");
        for (ProcessDefinition def : definitions) {
            Assert.assertTrue((boolean)expectedProcessIds.contains(def.getId()));
        }
    }

    @Test
    public void testGetProcessIds() {
        Collection definitions = this.runtimeDataService.getProcessIds(this.deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)definitions);
        Assert.assertEquals((long)3L, (long)definitions.size());
        Assert.assertTrue((boolean)definitions.contains("org.jbpm.writedocument.empty"));
        Assert.assertTrue((boolean)definitions.contains("org.jbpm.writedocument"));
        Assert.assertTrue((boolean)definitions.contains("org.jboss.qa.bpms.HumanTask"));
    }

    @Test
    public void testGetProcessInstances() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByState() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstances(states, null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(states, null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByStateAndInitiator() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(1);
        instances = this.runtimeDataService.getProcessInstances(states, "anonymous", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        instances = this.runtimeDataService.getProcessInstances(states, "wrongUser", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(states, "anonymous", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByDeploymentIdAndState() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByDeploymentId(this.deploymentUnit.getIdentifier(), states, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByDeploymentId(this.deploymentUnit.getIdentifier(), states, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByProcessId() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        ProcessInstanceDesc instance = (ProcessInstanceDesc)instances.iterator().next();
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        instance = (ProcessInstanceDesc)instances.iterator().next();
        Assert.assertEquals((long)3L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
    }

    @Test
    public void testGetProcessInstancesByProcessIdAndStatus() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        Long processInstanceIdToAbort = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        ArrayList<Integer> statuses = new ArrayList<Integer>();
        statuses.add(1);
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", statuses, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)2L, (long)instances.size());
        for (ProcessInstanceDesc instance : instances) {
            Assert.assertEquals((long)1L, (long)instance.getState().intValue());
            Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        }
        this.processService.abortProcessInstance(processInstanceIdToAbort);
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", statuses, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        ProcessInstanceDesc instance2 = (ProcessInstanceDesc)instances.iterator().next();
        Assert.assertEquals((long)1L, (long)instance2.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance2.getProcessId());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        statuses.clear();
        statuses.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", statuses, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)2L, (long)instances.size());
        for (ProcessInstanceDesc instance : instances) {
            Assert.assertEquals((long)3L, (long)instance.getState().intValue());
            Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        }
    }

    @Test
    public void testGetProcessInstanceById() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstanceDesc instance = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        this.processService.abortProcessInstance(this.processInstanceId);
        instance = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        this.processInstanceId = null;
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)3L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
    }

    @Test
    public void testGetProcessInstanceByCorrelationKey() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey("my business key");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", key);
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstanceDesc instance = this.runtimeDataService.getProcessInstanceByCorrelationKey(key);
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        Assert.assertEquals((Object)"my business key", (Object)instance.getCorrelationKey());
        List tasks = instance.getActiveTasks();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        UserTaskInstanceDesc activeTask = (UserTaskInstanceDesc)tasks.get(0);
        Assert.assertNotNull((Object)activeTask);
        Assert.assertEquals((Object)Status.Reserved.name(), (Object)activeTask.getStatus());
        Assert.assertEquals((Object)instance.getId(), (Object)activeTask.getProcessInstanceId());
        Assert.assertEquals((Object)instance.getProcessId(), (Object)activeTask.getProcessId());
        Assert.assertEquals((Object)"Write a Document", (Object)activeTask.getName());
        Assert.assertEquals((Object)"salaboy", (Object)activeTask.getActualOwner());
        Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)activeTask.getDeploymentId());
        this.processService.abortProcessInstance(this.processInstanceId);
        instance = this.runtimeDataService.getProcessInstanceByCorrelationKey(key);
        this.processInstanceId = null;
        Assert.assertNull((Object)instance);
    }

    @Test
    public void testGetProcessInstancesByCorrelationKey() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey("my business key");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", key);
        Assert.assertNotNull((Object)this.processInstanceId);
        Collection keyedInstances = this.runtimeDataService.getProcessInstancesByCorrelationKey(key, new QueryContext());
        Assert.assertNotNull((Object)keyedInstances);
        Assert.assertEquals((long)1L, (long)keyedInstances.size());
        ProcessInstanceDesc instance = (ProcessInstanceDesc)keyedInstances.iterator().next();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        Assert.assertEquals((Object)"my business key", (Object)instance.getCorrelationKey());
        List tasks = instance.getActiveTasks();
        Assert.assertNull((Object)tasks);
        this.processService.abortProcessInstance(this.processInstanceId);
        instance = this.runtimeDataService.getProcessInstanceByCorrelationKey(key);
        this.processInstanceId = null;
        Assert.assertNull((Object)instance);
        keyedInstances = this.runtimeDataService.getProcessInstancesByCorrelationKey(key, new QueryContext());
        Assert.assertNotNull((Object)keyedInstances);
        Assert.assertEquals((long)1L, (long)keyedInstances.size());
        instance = (ProcessInstanceDesc)keyedInstances.iterator().next();
        Assert.assertEquals((long)3L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        Assert.assertEquals((Object)"my business key", (Object)instance.getCorrelationKey());
    }

    @Test
    public void testGetProcessInstancesByProcessIdAndState() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByPartialProcessIdAndState() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm%", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm%", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByProcessIdAndStateAndInitiator() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(1);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", "anonymous", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", "wrongUser", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", "anonymous", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByProcessNameAndState() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessName(states, "humanTaskSample", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessName(states, "humanTaskSample", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByPartialProcessNameAndState() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessName(states, "human%", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessName(states, "human%", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByProcessNameAndStateAndInitiator() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(1);
        instances = this.runtimeDataService.getProcessInstancesByProcessName(states, "humanTaskSample", "anonymous", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        instances = this.runtimeDataService.getProcessInstancesByProcessName(states, "humanTaskSample", "wrongUser", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessName(states, "humanTaskSample", "anonymous", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstanceHistory() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        Collection instances = this.runtimeDataService.getProcessInstanceHistoryActive(this.processInstanceId.longValue(), new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        instances = this.runtimeDataService.getProcessInstanceHistoryCompleted(this.processInstanceId.longValue(), new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        instances = this.runtimeDataService.getProcessInstanceFullHistory(this.processInstanceId.longValue(), new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)3L, (long)instances.size());
        instances = this.runtimeDataService.getProcessInstanceFullHistoryByType(this.processInstanceId.longValue(), RuntimeDataService.EntryType.START, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)2L, (long)instances.size());
        instances = this.runtimeDataService.getProcessInstanceFullHistoryByType(this.processInstanceId.longValue(), RuntimeDataService.EntryType.END, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
    }

    @Test
    public void testGetNodeInstanceForWorkItem() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstance instance = this.processService.getProcessInstance(this.processInstanceId);
        Assert.assertNotNull((Object)instance);
        Collection activeNodes = ((WorkflowProcessInstanceImpl)instance).getNodeInstances();
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        NodeInstance node = (NodeInstance)activeNodes.iterator().next();
        Assert.assertNotNull((Object)node);
        Assert.assertTrue((boolean)(node instanceof WorkItemNodeInstance));
        Long workItemId = ((WorkItemNodeInstance)node).getWorkItemId();
        Assert.assertNotNull((Object)workItemId);
        NodeInstanceDesc desc = this.runtimeDataService.getNodeInstanceForWorkItem(workItemId);
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((Object)this.processInstanceId, (Object)desc.getProcessInstanceId());
        Assert.assertEquals((Object)"Write a Document", (Object)desc.getName());
        Assert.assertEquals((Object)"HumanTaskNode", (Object)desc.getNodeType());
    }

    @Test
    public void testGetVariableLogs() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        Collection variableLogs = this.runtimeDataService.getVariableHistory(this.processInstanceId.longValue(), "approval_document", new QueryContext());
        Assert.assertNotNull((Object)variableLogs);
        Assert.assertEquals((long)1L, (long)variableLogs.size());
        this.processService.setProcessVariable(this.processInstanceId, "approval_document", (Object)"updated content");
        variableLogs = this.runtimeDataService.getVariableHistory(this.processInstanceId.longValue(), "approval_document", new QueryContext());
        Assert.assertNotNull((Object)variableLogs);
        Assert.assertEquals((long)2L, (long)variableLogs.size());
        this.processService.setProcessVariable(this.processInstanceId, "approval_reviewComment", (Object)"under review - content");
        variableLogs = this.runtimeDataService.getVariablesCurrentState(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)variableLogs);
        Assert.assertEquals((long)2L, (long)variableLogs.size());
        for (VariableDesc vDesc : variableLogs) {
            if (vDesc.getVariableId().equals("approval_document")) {
                Assert.assertEquals((Object)"updated content", (Object)vDesc.getNewValue());
                continue;
            }
            if (!vDesc.getVariableId().equals("approval_reviewComment")) continue;
            Assert.assertEquals((Object)"under review - content", (Object)vDesc.getNewValue());
        }
    }

    @Test
    public void testGetTaskByWorkItemId() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstance instance = this.processService.getProcessInstance(this.processInstanceId);
        Assert.assertNotNull((Object)instance);
        Collection activeNodes = ((WorkflowProcessInstanceImpl)instance).getNodeInstances();
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        NodeInstance node = (NodeInstance)activeNodes.iterator().next();
        Assert.assertNotNull((Object)node);
        Assert.assertTrue((boolean)(node instanceof WorkItemNodeInstance));
        Long workItemId = ((WorkItemNodeInstance)node).getWorkItemId();
        Assert.assertNotNull((Object)workItemId);
        UserTaskInstanceDesc userTask = this.runtimeDataService.getTaskByWorkItemId(workItemId);
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)this.processInstanceId, (Object)userTask.getProcessInstanceId());
        Assert.assertEquals((Object)"Write a Document", (Object)userTask.getName());
    }

    @Test
    public void testGetTaskById() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstance instance = this.processService.getProcessInstance(this.processInstanceId);
        Assert.assertNotNull((Object)instance);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        UserTaskInstanceDesc userTask = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)this.processInstanceId, (Object)userTask.getProcessInstanceId());
        Assert.assertEquals((Object)"Write a Document", (Object)userTask.getName());
    }

    @Test
    public void testGetTaskOwned() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jboss.qa.bpms.HumanTask");
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstance instance = this.processService.getProcessInstance(this.processInstanceId);
        Assert.assertNotNull((Object)instance);
        List tasks = this.runtimeDataService.getTasksOwned("john", new QueryFilter(0, 5));
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary userTask = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)this.processInstanceId, (Object)userTask.getProcessInstanceId());
        Assert.assertEquals((Object)"Hello", (Object)userTask.getName());
        Assert.assertEquals((Object)"john", (Object)userTask.getActualOwnerId());
        Assert.assertEquals((Object)"Reserved", (Object)userTask.getStatusId());
        Assert.assertNotNull((Object)userTask.getActualOwner());
    }

    @Test
    public void testGetTaskAssignedAsBusinessAdmin() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        this.processService.getProcessInstance(this.processInstanceId);
        List tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministrator("Administrator", new QueryFilter(0, 5));
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary userTask = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)this.processInstanceId, (Object)userTask.getProcessInstanceId());
        Assert.assertEquals((Object)"Write a Document", (Object)userTask.getName());
    }

    @Test
    public void testGetTaskAssignedAsBusinessAdminPaging() {
        for (int i = 0; i < 10; ++i) {
            this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        }
        List tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministrator("Administrator", new QueryFilter(0, 5));
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)5L, (long)tasks.size());
        TaskSummary userTask = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"Write a Document", (Object)userTask.getName());
        Collection activeProcesses = this.runtimeDataService.getProcessInstances(new QueryContext(Integer.valueOf(0), Integer.valueOf(20)));
        for (ProcessInstanceDesc pi : activeProcesses) {
            this.processService.abortProcessInstance(pi.getId());
        }
    }

    @Test
    public void testGetTaskAssignedAsBusinessAdminPagingAndFiltering() {
        long processInstanceId = -1L;
        for (int i = 0; i < 10; ++i) {
            processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        }
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("processInstanceId", processInstanceId);
        QueryFilter qf = new QueryFilter("t.taskData.processInstanceId = :processInstanceId", params, "t.id", false);
        qf.setOffset(Integer.valueOf(0));
        qf.setCount(Integer.valueOf(5));
        List tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministrator("Administrator", qf);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary userTask = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"Write a Document", (Object)userTask.getName());
        Assert.assertEquals((long)processInstanceId, (long)userTask.getProcessInstanceId());
        Collection activeProcesses = this.runtimeDataService.getProcessInstances(new QueryContext(Integer.valueOf(0), Integer.valueOf(20)));
        for (ProcessInstanceDesc pi : activeProcesses) {
            this.processService.abortProcessInstance(pi.getId());
        }
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerByStatusPagingAndFiltering() {
        ArrayList<Long> processInstanceIds = new ArrayList<Long>();
        for (int i = 0; i < 10; ++i) {
            processInstanceIds.add(this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument"));
        }
        HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>();
        params.put("processInstanceId", processInstanceIds);
        QueryFilter qf = new QueryFilter("t.taskData.processInstanceId in (:processInstanceId)", params, "t.id", false);
        qf.setOffset(Integer.valueOf(0));
        qf.setCount(Integer.valueOf(5));
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Ready);
        statuses.add(Status.Reserved);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwnerByStatus("salaboy", statuses, qf);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)5L, (long)tasks.size());
        TaskSummary userTask = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"Write a Document", (Object)userTask.getName());
        Collection activeProcesses = this.runtimeDataService.getProcessInstances(new QueryContext(Integer.valueOf(0), Integer.valueOf(20)));
        for (ProcessInstanceDesc pi : activeProcesses) {
            this.processService.abortProcessInstance(pi.getId());
        }
    }

    @Test
    public void testTasksByStatusByProcessInstanceIdPagingAndFiltering() {
        Long pid = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Ready);
        statuses.add(Status.Reserved);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwnerByStatus("salaboy", statuses, new QueryFilter(0, 5));
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        this.userTaskService.start(Long.valueOf(taskId), "salaboy");
        this.userTaskService.complete(Long.valueOf(taskId), "salaboy", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "Review Document");
        QueryFilter qf = new QueryFilter("t.name = :name", params, "t.id", false);
        qf.setOffset(Integer.valueOf(0));
        qf.setCount(Integer.valueOf(5));
        tasks = this.runtimeDataService.getTasksByStatusByProcessInstanceId(pid, statuses, qf);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary userTask = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"Review Document", (Object)userTask.getName());
        tasks = this.runtimeDataService.getTasksByStatusByProcessInstanceId(pid, statuses, new QueryFilter(0, 5));
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        Collection activeProcesses = this.runtimeDataService.getProcessInstances(new QueryContext(Integer.valueOf(0), Integer.valueOf(20)));
        for (ProcessInstanceDesc pi : activeProcesses) {
            this.processService.abortProcessInstance(pi.getId());
        }
    }

    @Test
    public void testGetTaskAudit() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstance instance = this.processService.getProcessInstance(this.processInstanceId);
        Assert.assertNotNull((Object)instance);
        Collection activeNodes = ((WorkflowProcessInstanceImpl)instance).getNodeInstances();
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        NodeInstance node = (NodeInstance)activeNodes.iterator().next();
        Assert.assertNotNull((Object)node);
        Assert.assertTrue((boolean)(node instanceof WorkItemNodeInstance));
        Long workItemId = ((WorkItemNodeInstance)node).getWorkItemId();
        Assert.assertNotNull((Object)workItemId);
        List auditTasks = this.runtimeDataService.getAllAuditTask("salaboy", new QueryFilter(0, 10));
        Assert.assertNotNull((Object)auditTasks);
        Assert.assertEquals((long)1L, (long)auditTasks.size());
        Assert.assertEquals((Object)"Write a Document", (Object)((AuditTask)auditTasks.get(0)).getName());
    }

    @Test
    public void testGetTaskEvents() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstance instance = this.processService.getProcessInstance(this.processInstanceId);
        Assert.assertNotNull((Object)instance);
        Collection activeNodes = ((WorkflowProcessInstanceImpl)instance).getNodeInstances();
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        NodeInstance node = (NodeInstance)activeNodes.iterator().next();
        Assert.assertNotNull((Object)node);
        Assert.assertTrue((boolean)(node instanceof WorkItemNodeInstance));
        Long workItemId = ((WorkItemNodeInstance)node).getWorkItemId();
        Assert.assertNotNull((Object)workItemId);
        UserTaskInstanceDesc userTask = this.runtimeDataService.getTaskByWorkItemId(workItemId);
        Assert.assertNotNull((Object)userTask);
        List auditTasks = this.runtimeDataService.getTaskEvents(userTask.getTaskId().longValue(), new QueryFilter());
        Assert.assertNotNull((Object)auditTasks);
        Assert.assertEquals((long)1L, (long)auditTasks.size());
        Assert.assertEquals((Object)TaskEvent.TaskEventType.ADDED, (Object)((TaskEvent)auditTasks.get(0)).getType());
        this.userTaskService.start(userTask.getTaskId(), "salaboy");
        auditTasks = this.runtimeDataService.getTaskEvents(userTask.getTaskId().longValue(), new QueryFilter());
        Assert.assertNotNull((Object)auditTasks);
        Assert.assertEquals((long)2L, (long)auditTasks.size());
        Assert.assertEquals((Object)TaskEvent.TaskEventType.ADDED, (Object)((TaskEvent)auditTasks.get(0)).getType());
        Assert.assertEquals((Object)TaskEvent.TaskEventType.STARTED, (Object)((TaskEvent)auditTasks.get(1)).getType());
    }

    @Test
    public void testGetProcessInstancesByVariable() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        Collection processInstanceLogs = this.runtimeDataService.getProcessInstancesByVariable("approval_document", null, new QueryContext());
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        this.processService.setProcessVariable(this.processInstanceId, "approval_document", (Object)"updated content");
        processInstanceLogs = this.runtimeDataService.getProcessInstancesByVariable("approval_reviewComment", null, new QueryContext());
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)0L, (long)processInstanceLogs.size());
        this.processService.setProcessVariable(this.processInstanceId, "approval_reviewComment", (Object)"under review - content");
        processInstanceLogs = this.runtimeDataService.getProcessInstancesByVariable("approval_reviewComment", null, new QueryContext());
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesByVariableAndValue() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        Collection processInstanceLogs = this.runtimeDataService.getProcessInstancesByVariableAndValue("approval_document", "initial content", null, new QueryContext());
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        this.processService.setProcessVariable(this.processInstanceId, "approval_document", (Object)"updated content");
        processInstanceLogs = this.runtimeDataService.getProcessInstancesByVariableAndValue("approval_document", "initial content", null, new QueryContext());
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)0L, (long)processInstanceLogs.size());
        processInstanceLogs = this.runtimeDataService.getProcessInstancesByVariableAndValue("approval_document", "updated content", null, new QueryContext());
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        processInstanceLogs = this.runtimeDataService.getProcessInstancesByVariableAndValue("approval_document", "updated%", null, new QueryContext());
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTasksByVariable() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", null);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        List tasksByVariable = this.runtimeDataService.taskSummaryQuery("salaboy").variableName(new String[]{"TaskName"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        tasksByVariable = this.runtimeDataService.getTasksByVariable("salaboy", "ReviewComment", null, new QueryContext());
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)0L, (long)tasksByVariable.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("ReviewComment", "document reviewed");
        this.userTaskService.saveContent(Long.valueOf(taskId), output);
        tasksByVariable = this.runtimeDataService.getTasksByVariable("salaboy", "ReviewComment", null, new QueryContext());
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTasksByVariableAndValue() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", null);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        List tasksByVariable = this.runtimeDataService.getTasksByVariableAndValue("salaboy", "TaskName", "Write a Document", null, new QueryContext());
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        tasksByVariable = this.runtimeDataService.getTasksByVariableAndValue("salaboy", "TaskName", "Write", null, new QueryContext());
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)0L, (long)tasksByVariable.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("ReviewComment", "document reviewed");
        this.userTaskService.saveContent(Long.valueOf(taskId), output);
        tasksByVariable = this.runtimeDataService.getTasksByVariableAndValue("salaboy", "ReviewComment", "document reviewed", null, new QueryContext());
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        tasksByVariable = this.runtimeDataService.getTasksByVariableAndValue("salaboy", "ReviewComment", "document%", null, new QueryContext());
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }
}

