/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.test;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.ejb.api.DeploymentServiceEJBLocal;
import org.jbpm.services.ejb.api.ProcessServiceEJBLocal;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBLocal;
import org.jbpm.services.ejb.api.UserTaskServiceEJBLocal;
import org.jbpm.services.ejb.impl.tx.TransactionalCommandServiceEJBImpl;
import org.jbpm.services.ejb.test.AbstractTestSupport;
import org.jbpm.services.task.commands.GetTaskCommand;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.UpdateStringCommand;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.scanner.KieMavenRepository;

@RunWith(value=Arquillian.class)
public class UserTaskServiceEJBIntegrationTest
extends AbstractTestSupport {
    private Long processInstanceId = null;
    private KModuleDeploymentUnit deploymentUnit = null;
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    @EJB
    private UserTaskServiceEJBLocal userTaskService;
    @EJB
    private DeploymentServiceEJBLocal deploymentService;
    @EJB
    private ProcessServiceEJBLocal processService;
    @EJB
    private RuntimeDataServiceEJBLocal runtimeDataService;
    @EJB(beanInterface=TransactionalCommandServiceEJBImpl.class)
    private TransactionalCommandService commandService;

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive war = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/sample-war-ejb-app.war"));
        war.addPackage("org.jbpm.services.ejb.test");
        UserTaskServiceEJBIntegrationTest.deployKjar();
        return war;
    }

    @Before
    public void prepare() {
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
    }

    protected static void deployKjar() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("processes/EmptyHumanTask.bpmn");
        processes.add("processes/humanTask.bpmn");
        InternalKieModule kJar1 = UserTaskServiceEJBIntegrationTest.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(UserTaskServiceEJBIntegrationTest.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        if (this.processInstanceId != null) {
            this.processService.abortProcessInstance(this.processInstanceId);
            ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
            Assert.assertNull((Object)pi);
        }
        int deleted = 0;
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  NodeInstanceLog nid"))).intValue();
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  ProcessInstanceLog pid"))).intValue();
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  VariableInstanceLog vsd"))).intValue();
        System.out.println("Deleted " + (deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  AuditTaskImpl vsd"))).intValue()));
        UserTaskServiceEJBIntegrationTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
    }

    @Test
    public void testActivate() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument.empty");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.activate(taskId, "Administrator");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Ready.toString(), (Object)task.getStatus());
    }

    @Test
    public void testReleaseAndClaim() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.release(taskId, "salaboy");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Ready.toString(), (Object)task.getStatus());
        this.userTaskService.claim(taskId, "salaboy");
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
    }

    @Test
    public void testStartAndComplete() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.start(taskId, "salaboy");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.InProgress.toString(), (Object)task.getStatus());
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("Result", "some document data");
        this.userTaskService.complete(taskId, "salaboy", results);
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Completed.toString(), (Object)task.getStatus());
    }

    @Test
    public void testDelegate() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.delegate(taskId, "Administrator", "john");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"john", (Object)task.getActualOwner());
    }

    @Test
    public void testExit() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.exit(taskId, "Administrator");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Exited.toString(), (Object)task.getStatus());
    }

    @Test
    public void testStartAndFail() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.start(taskId, "salaboy");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.InProgress.toString(), (Object)task.getStatus());
        this.userTaskService.fail(taskId, "Administrator", new HashMap());
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Failed.toString(), (Object)task.getStatus());
    }

    @Test
    public void testStartAndForward() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.start(taskId, "salaboy");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.InProgress.toString(), (Object)task.getStatus());
        this.userTaskService.forward(taskId, "salaboy", "john");
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Ready.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"", (Object)task.getActualOwner());
    }

    @Test
    public void testSuspendAndResume() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.suspend(taskId, "salaboy");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Suspended.toString(), (Object)task.getStatus());
        this.userTaskService.resume(taskId, "salaboy");
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
    }

    @Test
    public void testStartAndStop() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.start(taskId, "salaboy");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.InProgress.toString(), (Object)task.getStatus());
        this.userTaskService.stop(taskId, "salaboy");
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
    }

    @Test
    public void testSkip() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.skip(taskId, "Administrator");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Obsolete.toString(), (Object)task.getStatus());
    }

    @Test
    public void testNominate() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument.empty");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        ArrayList<User> owners = new ArrayList<User>();
        User user = TaskModelProvider.getFactory().newUser("john");
        owners.add(user);
        user = TaskModelProvider.getFactory().newUser("salaboy");
        owners.add(user);
        this.userTaskService.nominate(taskId, "Administrator", owners);
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Ready.toString(), (Object)task.getStatus());
    }

    @Test
    public void testSetPriority() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((long)0L, (long)task.getPriority().intValue());
        this.userTaskService.setPriority(taskId, 8);
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((long)8L, (long)task.getPriority().intValue());
    }

    @Test
    public void testSetExpirationDate() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Date origDueDate = task.getDueDate();
        Assert.assertNull((Object)origDueDate);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.userTaskService.setExpirationDate(taskId, sdf.parse("2013-12-31"));
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"2013-12-31", (Object)sdf.format(task.getDueDate()));
    }

    @Test
    public void testSetSkippable() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        Task taskInstance = this.userTaskService.getTask(taskId);
        Assert.assertNotNull((Object)taskInstance);
        Assert.assertEquals((Object)Status.Reserved, (Object)taskInstance.getTaskData().getStatus());
        Assert.assertTrue((boolean)taskInstance.getTaskData().isSkipable());
        this.userTaskService.setSkipable(taskId, false);
        taskInstance = this.userTaskService.getTask(taskId);
        Assert.assertNotNull((Object)taskInstance);
        Assert.assertEquals((Object)Status.Reserved, (Object)taskInstance.getTaskData().getStatus());
        Assert.assertFalse((boolean)taskInstance.getTaskData().isSkipable());
    }

    @Test
    public void testSetName() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"Write a Document", (Object)task.getName());
        this.userTaskService.setName(taskId, "updated");
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"updated", (Object)task.getName());
    }

    @Test
    public void testSetDescription() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"Write a Document", (Object)task.getDescription());
        this.userTaskService.setDescription(taskId, "updated");
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"updated", (Object)task.getDescription());
    }

    @Test
    public void testContentRelatedOperations() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        Map input = this.userTaskService.getTaskInputContentByTaskId(taskId);
        Assert.assertNotNull((Object)input);
        Assert.assertEquals((long)5L, (long)input.size());
        Assert.assertTrue((boolean)input.containsKey("ActorId"));
        Assert.assertTrue((boolean)input.containsKey("Comment"));
        Assert.assertTrue((boolean)input.containsKey("TaskName"));
        Assert.assertTrue((boolean)input.containsKey("NodeName"));
        Assert.assertTrue((boolean)input.containsKey("Priority"));
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("Content", "testing save");
        values.put("Author", "john");
        Long contentId = this.userTaskService.saveContent(taskId, values);
        Assert.assertNotNull((Object)contentId);
        Map output = this.userTaskService.getTaskOutputContentByTaskId(taskId);
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((long)2L, (long)output.size());
        Assert.assertTrue((boolean)output.containsKey("Content"));
        Assert.assertTrue((boolean)output.containsKey("Author"));
        this.userTaskService.deleteContent(taskId, contentId);
        output = this.userTaskService.getTaskOutputContentByTaskId(taskId);
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((long)0L, (long)output.size());
    }

    @Test
    public void testCommentOperations() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        List comments = this.userTaskService.getCommentsByTaskId(taskId);
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((long)0L, (long)comments.size());
        Long commentId = this.userTaskService.addComment(taskId, "Simple comment", "john", new Date());
        Assert.assertNotNull((Object)commentId);
        Long commentId2 = this.userTaskService.addComment(taskId, "Another comment", "john", new Date());
        Assert.assertNotNull((Object)commentId2);
        comments = this.userTaskService.getCommentsByTaskId(taskId);
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((long)2L, (long)comments.size());
        Comment cm = this.userTaskService.getCommentById(taskId, commentId2);
        Assert.assertNotNull((Object)cm);
        Assert.assertEquals((Object)"john", (Object)cm.getAddedBy().getId());
        Assert.assertEquals((Object)"Another comment", (Object)cm.getText());
        this.userTaskService.deleteComment(taskId, commentId2);
        comments = this.userTaskService.getCommentsByTaskId(taskId);
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((long)1L, (long)comments.size());
    }

    @Test
    public void testAttachmentOperations() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        List attachments = this.userTaskService.getAttachmentsByTaskId(taskId);
        Assert.assertNotNull((Object)attachments);
        Assert.assertEquals((long)0L, (long)attachments.size());
        Long attId = this.userTaskService.addAttachment(taskId, "john", "my attachment", (Object)"String attachment");
        Assert.assertNotNull((Object)attId);
        attachments = this.userTaskService.getAttachmentsByTaskId(taskId);
        Assert.assertNotNull((Object)attachments);
        Assert.assertEquals((long)1L, (long)attachments.size());
        String content = (String)this.userTaskService.getAttachmentContentById(taskId, attId);
        Assert.assertNotNull((Object)content);
        Assert.assertEquals((Object)"String attachment", (Object)content);
        Attachment attachment = this.userTaskService.getAttachmentById(taskId, attId);
        Assert.assertNotNull((Object)attachment);
        Assert.assertEquals((Object)"john", (Object)attachment.getAttachedBy().getId());
        Assert.assertEquals((Object)"my attachment", (Object)attachment.getName());
        Assert.assertNotNull((Object)attachment.getAttachmentContentId());
        this.userTaskService.deleteAttachment(taskId, attId);
        attachments = this.userTaskService.getAttachmentsByTaskId(taskId);
        Assert.assertNotNull((Object)attachments);
        Assert.assertEquals((long)0L, (long)attachments.size());
    }

    @Test
    public void testExecute() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        Task task = (Task)this.userTaskService.execute(this.deploymentUnit.getIdentifier(), (Command)new GetTaskCommand(taskId.longValue()));
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        Assert.assertEquals((Object)"Write a Document", (Object)task.getName());
    }
}

