/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.test;

import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTestSupport.class);
    protected static final String ARTIFACT_ID = "test-module";
    protected static final String GROUP_ID = "org.jbpm.test";
    protected static final String VERSION = "1.0.0";

    protected static String getPom(ReleaseId releaseId, ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    protected static InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, List<String> resources) {
        return AbstractTestSupport.createKieJar(ks, releaseId, resources, null);
    }

    protected static InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, List<String> resources, Map<String, String> extraResources) {
        KieFileSystem kfs = AbstractTestSupport.createKieFileSystemWithKProject(ks);
        kfs.writePomXML(AbstractTestSupport.getPom(releaseId, new ReleaseId[0]));
        for (String string : resources) {
            kfs.write("src/main/resources/KBase-test/" + string, ResourceFactory.newClassPathResource((String)string));
        }
        if (extraResources != null) {
            for (Map.Entry entry : extraResources.entrySet()) {
                kfs.write((String)entry.getKey(), ResourceFactory.newByteArrayResource((byte[])((String)entry.getValue()).getBytes()));
            }
        }
        kfs.write("src/main/resources/forms/DefaultProcess.ftl", ResourceFactory.newClassPathResource((String)"repo/globals/forms/DefaultProcess.ftl"));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        List list = kieBuilder.buildAll().getResults().getMessages();
        if (!list.isEmpty()) {
            for (Message message : list) {
                logger.error("Error Message: ({}) {}", (Object)message.getPath(), (Object)message.getText());
            }
            throw new RuntimeException("There are errors builing the package, please check your knowledge assets!");
        }
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected static KieFileSystem createKieFileSystemWithKProject(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase-test").setDefault(true).addPackage("*").setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        kieBaseModel1.newKieSessionModel("ksession-test").setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime")).newWorkItemHandlerModel("Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()");
        kieBaseModel1.newKieSessionModel("ksession-test2").setDefault(false).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime"));
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    protected static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                logger.debug("Temp dir to be removed {} file {}", (Object)tempDir, (Object)file);
                new File(tempDir, file).delete();
            }
        }
    }
}

