/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.ejb.api.DefinitionServiceEJBLocal;
import org.jbpm.services.ejb.api.DeploymentServiceEJBLocal;
import org.jbpm.services.ejb.test.AbstractTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.KieMavenRepository;

@RunWith(value=Arquillian.class)
public class DefinitionServiceEJBIntegrationTest
extends AbstractTestSupport {
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    @EJB
    private DefinitionServiceEJBLocal bpmn2Service;
    @EJB
    private DeploymentServiceEJBLocal deploymentService;

    @Deployment
    public static WebArchive createDeployment() {
        File archive = new File("target/sample-war-ejb-app.war");
        if (!archive.exists()) {
            throw new IllegalStateException("There is no archive yet generated, run maven build or mvn assembly:assembly");
        }
        WebArchive war = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)archive);
        war.addPackage("org.jbpm.services.ejb.test");
        DefinitionServiceEJBIntegrationTest.deployKjar();
        return war;
    }

    protected static void deployKjar() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("processes/hiring.bpmn2");
        processes.add("processes/customtask.bpmn");
        processes.add("processes/humanTask.bpmn");
        processes.add("processes/signal.bpmn");
        processes.add("processes/import.bpmn");
        processes.add("processes/callactivity.bpmn");
        processes.add("processes/itemrefissue.bpmn");
        InternalKieModule kJar1 = DefinitionServiceEJBIntegrationTest.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(DefinitionServiceEJBIntegrationTest.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        DefinitionServiceEJBIntegrationTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
    }

    @Test
    public void testHumanTaskProcess() throws IOException {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String processId = "org.jbpm.writedocument";
        Collection processTasks = this.bpmn2Service.getTasksDefinitions(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)3L, (long)processTasks.size());
        Map processData = this.bpmn2Service.getProcessVariables(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)3L, (long)processData.keySet().size());
        Map taskInputMappings = this.bpmn2Service.getTaskInputMappings(deploymentUnit.getIdentifier(), processId, "Write a Document");
        Assert.assertEquals((long)3L, (long)taskInputMappings.keySet().size());
        Map taskOutputMappings = this.bpmn2Service.getTaskOutputMappings(deploymentUnit.getIdentifier(), processId, "Write a Document");
        Assert.assertEquals((long)1L, (long)taskOutputMappings.keySet().size());
        Map associatedEntities = this.bpmn2Service.getAssociatedEntities(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)3L, (long)associatedEntities.keySet().size());
    }

    @Test
    public void testHiringProcessData() throws IOException {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String processId = "hiring";
        Collection processTasks = this.bpmn2Service.getTasksDefinitions(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)4L, (long)processTasks.size());
        Map processData = this.bpmn2Service.getProcessVariables(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)9L, (long)processData.keySet().size());
        Map taskInputMappings = this.bpmn2Service.getTaskInputMappings(deploymentUnit.getIdentifier(), processId, "HR Interview");
        Assert.assertEquals((long)4L, (long)taskInputMappings.keySet().size());
        Assert.assertEquals((Object)"java.lang.String", taskInputMappings.get("TaskName"));
        Assert.assertEquals((Object)"Object", taskInputMappings.get("GroupId"));
        Assert.assertEquals((Object)"Object", taskInputMappings.get("Comment"));
        Assert.assertEquals((Object)"String", taskInputMappings.get("in_name"));
        Map taskOutputMappings = this.bpmn2Service.getTaskOutputMappings(deploymentUnit.getIdentifier(), processId, "HR Interview");
        Assert.assertEquals((long)4L, (long)taskOutputMappings.keySet().size());
        Assert.assertEquals((Object)"String", taskOutputMappings.get("out_name"));
        Assert.assertEquals((Object)"Integer", taskOutputMappings.get("out_age"));
        Assert.assertEquals((Object)"String", taskOutputMappings.get("out_mail"));
        Assert.assertEquals((Object)"Integer", taskOutputMappings.get("out_score"));
        Map associatedEntities = this.bpmn2Service.getAssociatedEntities(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)4L, (long)associatedEntities.keySet().size());
        Map allServiceTasks = this.bpmn2Service.getServiceTasks(deploymentUnit.getIdentifier(), processId);
        Assert.assertEquals((long)2L, (long)allServiceTasks.keySet().size());
    }

    @Test
    public void testFindReusableSubProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String theString = "ParentProcess";
        Assert.assertNotNull((Object)theString);
        Collection reusableProcesses = this.bpmn2Service.getReusableSubProcesses(deploymentUnit.getIdentifier(), theString);
        Assert.assertNotNull((Object)reusableProcesses);
        Assert.assertEquals((long)1L, (long)reusableProcesses.size());
        Assert.assertEquals((Object)"signal", reusableProcesses.iterator().next());
    }

    @Test
    public void itemRefIssue() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String processId = "itemrefissue";
        Map processData = this.bpmn2Service.getProcessVariables(deploymentUnit.getIdentifier(), processId);
        Assert.assertNotNull((Object)processData);
    }

    @Test
    public void testHumanTaskProcessBeforeAndAfterUndeploy() throws IOException {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String processId = "org.jbpm.writedocument";
        ProcessDefinition procDef = this.bpmn2Service.getProcessDefinition(deploymentUnit.getIdentifier(), processId);
        Assert.assertNotNull((Object)procDef);
        Assert.assertEquals((Object)procDef.getId(), (Object)"org.jbpm.writedocument");
        Assert.assertEquals((Object)procDef.getName(), (Object)"humanTaskSample");
        Assert.assertEquals((Object)procDef.getKnowledgeType(), (Object)"PROCESS");
        Assert.assertEquals((Object)procDef.getPackageName(), (Object)"defaultPackage");
        Assert.assertEquals((Object)procDef.getType(), (Object)"RuleFlow");
        Assert.assertEquals((Object)procDef.getVersion(), (Object)"1");
        this.deploymentService.undeploy((DeploymentUnit)deploymentUnit);
        procDef = this.bpmn2Service.getProcessDefinition(deploymentUnit.getIdentifier(), processId);
        Assert.assertNull((Object)procDef);
    }
}

