/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.gateway;

import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExclusiveGatewayTest
extends JbpmTestCase {
    private static final String EXCLUSIVE_GATEWAY = "org/jbpm/test/functional/gateway/ExclusiveGateway.bpmn";
    private static final String EXCLUSIVE_GATEWAY_ID = "org.jbpm.test.functional.gateway.ExclusiveGateway";
    private KieSession ksession;
    private IterableProcessEventListener iterableListener;

    public ExclusiveGatewayTest() {
        super(false);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ksession = this.createKSession(EXCLUSIVE_GATEWAY);
        this.iterableListener = new IterableProcessEventListener();
    }

    @Test(timeout=30000L)
    public void testExclusive1() {
        Assume.assumeFalse((boolean)EXCLUSIVE_GATEWAY_ID.contains("ExclusiveGateway-eclipse"));
        this.ksession.addEventListener((ProcessEventListener)this.iterableListener);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("x", 5);
        Element el = this.createTestElement("sample", "value", "test");
        params.put("element", el);
        StartProcessCommand spc = new StartProcessCommand();
        spc.setProcessId(EXCLUSIVE_GATEWAY_ID);
        spc.setParameters(params);
        this.ksession.execute((Command)spc);
        IterableListenerAssert.assertMultipleVariablesChanged((IterableProcessEventListener)this.iterableListener, (String[])new String[]{"element", "x"});
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)this.iterableListener, (String)EXCLUSIVE_GATEWAY_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"insertScript");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"fork1");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"script2");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"join");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"fork2");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"end1");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)this.iterableListener, (String)EXCLUSIVE_GATEWAY_ID);
    }

    @Test(timeout=30000L)
    public void testExclusive2() {
        Assume.assumeFalse((boolean)EXCLUSIVE_GATEWAY_ID.contains("ExclusiveGateway-eclipse"));
        this.ksession.addEventListener((ProcessEventListener)this.iterableListener);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("x", 15);
        Element el = this.createTestElement("sample", "value", "test");
        params.put("element", el);
        StartProcessCommand spc = new StartProcessCommand();
        spc.setProcessId(EXCLUSIVE_GATEWAY_ID);
        spc.setParameters(params);
        this.ksession.execute((Command)spc);
        IterableListenerAssert.assertMultipleVariablesChanged((IterableProcessEventListener)this.iterableListener, (String[])new String[]{"element", "x"});
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)this.iterableListener, (String)EXCLUSIVE_GATEWAY_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"insertScript");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"fork1");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"script1");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"join");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"fork2");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"end1");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)this.iterableListener, (String)EXCLUSIVE_GATEWAY_ID);
    }

    @Test(timeout=30000L)
    public void testExclusive3() {
        Assume.assumeFalse((boolean)EXCLUSIVE_GATEWAY_ID.contains("ExclusiveGateway-eclipse"));
        this.ksession.addEventListener((ProcessEventListener)this.iterableListener);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("x", -1);
        Element el = this.createTestElement("sample", "value", "test");
        params.put("element", el);
        StartProcessCommand spc = new StartProcessCommand();
        spc.setProcessId(EXCLUSIVE_GATEWAY_ID);
        spc.setParameters(params);
        this.ksession.execute((Command)spc);
        IterableListenerAssert.assertMultipleVariablesChanged((IterableProcessEventListener)this.iterableListener, (String[])new String[]{"element", "x"});
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)this.iterableListener, (String)EXCLUSIVE_GATEWAY_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"insertScript");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"fork1");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"script3");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"join");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"fork2");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"end1");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)this.iterableListener, (String)EXCLUSIVE_GATEWAY_ID);
    }

    private Element createTestElement(String name, String attribute, String attrValue) {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        Attr attr = doc.createAttribute(attribute);
        attr.setValue(attrValue);
        Element element = doc.createElement(name);
        element.setAttributeNode(attr);
        return element;
    }
}

