/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.actions;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.actions.CaseActionsPresenter;
import org.jbpm.workbench.cm.model.CaseStageSummary;
import org.jbpm.workbench.cm.util.CaseActionType;
import org.uberfire.client.views.pfly.widgets.FormGroup;
import org.uberfire.client.views.pfly.widgets.FormLabel;
import org.uberfire.client.views.pfly.widgets.Modal;
import org.uberfire.client.views.pfly.widgets.Select;
import org.uberfire.client.views.pfly.widgets.ValidationState;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class NewActionViewImpl
implements CaseActionsPresenter.NewActionView {
    @Inject
    @DataField(value="action-creation-title")
    private Span modalTitle;
    @Inject
    @DataField(value="action-name-group")
    private FormGroup actionNameGroup;
    @Inject
    @DataField(value="action-name-label")
    private FormLabel actionNameLabel;
    @Inject
    @DataField(value="action-name-input")
    private TextInput actionNameInput;
    @Inject
    @DataField(value="action-name-help")
    private Span actionNameHelp;
    @Inject
    @DataField(value="action-desc-group")
    private FormGroup actionDescGroup;
    @Inject
    @DataField(value="action-desc-input")
    private TextInput actionDescInput;
    @Inject
    @DataField(value="action-users-group")
    private FormGroup actionUsersGroup;
    @Inject
    @DataField(value="action-users-input")
    private TextInput actionUsersInput;
    @Inject
    @DataField(value="action-groups-group")
    private FormGroup actionGroupsGroup;
    @Inject
    @DataField(value="action-groups-input")
    private TextInput actionGroupsInput;
    @Inject
    @DataField(value="assignation-help")
    private Span assignationHelp;
    @Inject
    @DataField(value="action-process-definitions-group")
    private FormGroup actionProcessDefinitionsGroup;
    @Inject
    @DataField(value="action-case-definitions-label")
    private FormLabel processDefinitionsLabel;
    @Inject
    @DataField(value="process-definitions-help")
    private Span processDefinitionsHelp;
    @Inject
    @DataField(value="stages-select")
    private Select stages;
    @Inject
    @DataField(value="action-process-definitions-select")
    private Select processDefinitionsList;
    @Inject
    @DataField(value="modal")
    private Modal modal;
    private Command okCommand;
    private CaseActionType caseActionType;
    @Inject
    private TranslationService translationService;

    @PostConstruct
    public void init() {
        this.actionNameLabel.addRequiredIndicator();
        this.processDefinitionsLabel.addRequiredIndicator();
    }

    public void init(CaseActionsPresenter presenter) {
    }

    @Override
    public void show(CaseActionType caseActionType, Command okCommand) {
        this.caseActionType = caseActionType;
        this.okCommand = okCommand;
        this.setInputFields();
        this.clearErrorMessages();
        this.clearValues();
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public void addStages(List<CaseStageSummary> activeStages) {
        activeStages.forEach(activeStage -> this.stages.addOption(activeStage.getName(), activeStage.getIdentifier()));
        this.stages.refresh();
    }

    @Override
    public String getStageId() {
        return this.stages.getValue();
    }

    @Override
    public void clearAllStages() {
        this.stages.removeAllOptions();
        this.stages.refresh();
    }

    private boolean validateForm() {
        boolean validForm = true;
        this.clearErrorMessages();
        if (Strings.isNullOrEmpty((String)this.actionNameInput.getValue())) {
            this.actionNameInput.focus();
            this.actionNameHelp.setTextContent(this.translationService.format("PleaseIntroActionName", new Object[0]));
            this.actionNameGroup.setValidationState(ValidationState.ERROR);
            validForm = false;
        }
        switch (this.caseActionType) {
            case DYNAMIC_USER_TASK: {
                if (!Strings.isNullOrEmpty((String)this.actionUsersInput.getValue()) || !Strings.isNullOrEmpty((String)this.actionGroupsInput.getValue())) break;
                this.actionUsersInput.focus();
                this.actionUsersGroup.setValidationState(ValidationState.ERROR);
                this.actionGroupsGroup.setValidationState(ValidationState.ERROR);
                this.assignationHelp.setTextContent(this.translationService.format("PleaseIntroUserOrGroupToAssignTheNewAction", new Object[0]));
                validForm = false;
                break;
            }
            case DYNAMIC_SUBPROCESS_TASK: {
                if (!Strings.isNullOrEmpty((String)this.processDefinitionsList.getValue())) break;
                this.processDefinitionsList.getElement().focus();
                this.actionProcessDefinitionsGroup.setValidationState(ValidationState.ERROR);
                this.processDefinitionsHelp.setTextContent(this.translationService.format("PleaseIntroSubprocessId", new Object[0]));
                validForm = false;
            }
        }
        if (validForm) {
            this.actionGroupsGroup.setValidationState(ValidationState.SUCCESS);
            this.actionUsersGroup.setValidationState(ValidationState.SUCCESS);
            this.actionNameGroup.setValidationState(ValidationState.SUCCESS);
            this.actionProcessDefinitionsGroup.setValidationState(ValidationState.SUCCESS);
        }
        return validForm;
    }

    private void clearValues() {
        this.actionUsersInput.setValue("");
        this.actionGroupsInput.setValue("");
        this.actionNameInput.setValue("");
        this.actionDescInput.setValue("");
        this.processDefinitionsList.setValue("");
        this.stages.setValue("");
    }

    private void clearErrorMessages() {
        this.actionNameHelp.setTextContent("");
        this.assignationHelp.setTextContent("");
        this.processDefinitionsHelp.setTextContent("");
        this.actionUsersGroup.clearValidationState();
        this.actionGroupsGroup.clearValidationState();
        this.actionNameGroup.clearValidationState();
        this.actionProcessDefinitionsGroup.clearValidationState();
    }

    @Override
    public void setProcessDefinitions(List<String> definitions) {
        for (String definition : definitions) {
            this.processDefinitionsList.addOption(definition);
        }
        this.processDefinitionsList.refresh();
    }

    @Override
    public void clearAllProcessDefinitions() {
        this.processDefinitionsList.removeAllOptions();
        this.processDefinitionsList.refresh();
    }

    @Override
    public String getTaskName() {
        return this.actionNameInput.getValue();
    }

    @Override
    public String getDescription() {
        return this.actionDescInput.getValue();
    }

    @Override
    public String getProcessDefinitionName() {
        return this.processDefinitionsList.getValue();
    }

    @Override
    public String getActors() {
        return this.actionUsersInput.getValue();
    }

    @Override
    public String getGroups() {
        return this.actionGroupsInput.getValue();
    }

    public HTMLElement getElement() {
        return this.modal.getElement();
    }

    private void setInputFields() {
        switch (this.caseActionType) {
            case DYNAMIC_USER_TASK: {
                this.modalTitle.setTextContent(this.translationService.format("NewUserTask", new Object[0]));
                DOMUtil.removeCSSClass((HTMLElement)this.actionDescGroup.getElement(), (String)"hidden");
                DOMUtil.removeCSSClass((HTMLElement)this.actionUsersGroup.getElement(), (String)"hidden");
                DOMUtil.removeCSSClass((HTMLElement)this.actionGroupsGroup.getElement(), (String)"hidden");
                DOMUtil.addCSSClass((HTMLElement)this.actionProcessDefinitionsGroup.getElement(), (String)"hidden");
                break;
            }
            case DYNAMIC_SUBPROCESS_TASK: {
                this.modalTitle.setTextContent(this.translationService.format("NewProcessTask", new Object[0]));
                DOMUtil.addCSSClass((HTMLElement)this.actionDescGroup.getElement(), (String)"hidden");
                DOMUtil.addCSSClass((HTMLElement)this.actionUsersGroup.getElement(), (String)"hidden");
                DOMUtil.addCSSClass((HTMLElement)this.actionGroupsGroup.getElement(), (String)"hidden");
                DOMUtil.removeCSSClass((HTMLElement)this.actionProcessDefinitionsGroup.getElement(), (String)"hidden");
            }
        }
    }

    @EventHandler(value={"addDynamicTask"})
    public void onAssignClick(@ForEvent(value={"click"}) MouseEvent event) {
        if (!this.validateForm()) {
            return;
        }
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
        this.hide();
    }

    @EventHandler(value={"cancel"})
    public void onCancelClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"close"})
    public void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }
}

