/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.roles.util;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.events.CaseRoleAssignmentListOpenEvent;
import org.jbpm.workbench.cm.client.roles.CaseRolesPresenter;
import org.jbpm.workbench.cm.client.util.AbstractView;

@Dependent
@Templated
public class ItemsLine
extends AbstractView<CaseRolesPresenter> {
    public static int MORE_LINK_SIZE = 60;
    @Inject
    @DataField(value="items-line")
    Div itemsLine;
    @Inject
    @DataField(value="visible-items")
    UnorderedList visibleItems;
    @Inject
    @DataField(value="hidden-items")
    UnorderedList hiddenItems;
    @Inject
    @DataField(value="custom-popover")
    Div customPopover;
    @Inject
    @DataField(value="more-items-link")
    Div moreItemsLinkDiv;
    String itemsLineId;
    boolean popoverOpen = false;
    private Event<CaseRoleAssignmentListOpenEvent> roleAssignmentListOpenEvent;

    @Inject
    public void setRoleAssignmentListOpenEvent(Event<CaseRoleAssignmentListOpenEvent> roleAssignmentListOpenEvent) {
        this.roleAssignmentListOpenEvent = roleAssignmentListOpenEvent;
    }

    public void initWithSingleItem(String itemsLineId, String item) {
        this.itemsLineId = itemsLineId;
        HTMLElement itemText = this.createElement("span");
        itemText.setTextContent(item);
        HTMLElement li = this.createElement("li");
        li.appendChild((Node)itemText);
        this.getVisibleUnorderedList().appendChild((Node)li);
    }

    public void initWithItemsLine(int maxWidth, String itemsLineId, List<CaseRolesPresenter.CaseAssignmentItem> items) {
        this.itemsLineId = itemsLineId;
        if (items.size() > 0) {
            boolean overflow = false;
            for (CaseRolesPresenter.CaseAssignmentItem item : items) {
                if (!overflow) {
                    this.addItem(item, this.getVisibleUnorderedList());
                    if (this.getVisibleUnorderedList().getBoundingClientRect().getWidth().intValue() + MORE_LINK_SIZE <= maxWidth) continue;
                    this.getVisibleUnorderedList().removeChild(this.getVisibleUnorderedList().getLastChild());
                    HTMLElement li = this.createElement("li");
                    li.appendChild((Node)this.getMoreItemsLinkDiv());
                    this.getVisibleUnorderedList().appendChild((Node)li);
                    overflow = true;
                    this.addItem(item, this.getHiddenUnorderedList());
                    DOMUtil.removeCSSClass((HTMLElement)this.getMoreItemsLinkDiv(), (String)"hidden");
                    continue;
                }
                this.addItem(item, this.getHiddenUnorderedList());
            }
        }
    }

    public void showAllItems() {
        DOMUtil.removeCSSClass((HTMLElement)this.customPopover, (String)"hidden");
        this.popoverOpen = true;
    }

    public void hideAllItems() {
        DOMUtil.addCSSClass((HTMLElement)this.customPopover, (String)"hidden");
        this.popoverOpen = false;
    }

    public void addItem(CaseRolesPresenter.CaseAssignmentItem item, UnorderedList itemList) {
        HTMLElement closeIcon = this.createElement("span");
        DOMUtil.addCSSClass((HTMLElement)closeIcon, (String)"pficon");
        DOMUtil.addCSSClass((HTMLElement)closeIcon, (String)"pficon-close");
        DOMUtil.addCSSClass((HTMLElement)closeIcon, (String)"kie-remove-role-item");
        HTMLElement itemText = this.createElement("span");
        itemText.setTextContent(item.label());
        HTMLElement a = this.createElement("a");
        a.appendChild((Node)closeIcon);
        a.setOnclick(e -> item.execute());
        itemText.appendChild((Node)a);
        HTMLElement li = this.createElement("li");
        li.appendChild((Node)itemText);
        itemList.appendChild((Node)li);
    }

    protected HTMLElement createElement(String type) {
        return Window.getDocument().createElement(type);
    }

    protected UnorderedList getVisibleUnorderedList() {
        return this.visibleItems;
    }

    protected UnorderedList getHiddenUnorderedList() {
        return this.hiddenItems;
    }

    public Div getMoreItemsLinkDiv() {
        return this.moreItemsLinkDiv;
    }

    public HTMLElement getElement() {
        return this.itemsLine;
    }

    @EventHandler(value={"more-items"})
    public void onMoreItems(@ForEvent(value={"click"}) org.jboss.errai.common.client.dom.Event event) {
        this.roleAssignmentListOpenEvent.fire((Object)new CaseRoleAssignmentListOpenEvent(this.itemsLineId));
        if (!this.popoverOpen) {
            this.showAllItems();
        } else {
            this.hideAllItems();
        }
    }
}

