/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xes;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSource;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.xes.XESExportServiceImpl;
import org.jbpm.xes.XESLogMarshaller;
import org.jbpm.xes.XESProcessFilter;
import org.jbpm.xes.dataset.DataSetService;
import org.jbpm.xes.dataset.DataSetServiceImpl;
import org.jbpm.xes.model.LogType;
import org.jbpm.xes.model.TraceType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;

public class XESProcessExportTest
extends JbpmJUnitBaseTestCase {
    private BasicDataSource xesDataSource;

    public XESProcessExportTest() {
        super(true, true);
    }

    public static BasicDataSource setupDataSource(String connectURI) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName("org.h2.Driver");
        ds.setUrl(connectURI);
        ds.setUsername("sa");
        ds.setPassword("");
        return ds;
    }

    @Before
    public void setup() {
        this.xesDataSource = XESProcessExportTest.setupDataSource("jdbc:h2:mem:jbpm-db;MVCC=true");
    }

    @After
    public void cleanup() throws Exception {
        if (this.xesDataSource != null) {
            this.xesDataSource.close();
        }
    }

    @Test
    public void testHelloProcess() throws Exception {
        this.createRuntimeManager(new String[]{"hello.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        int instances = 5;
        IntStream.range(0, instances).forEach(i -> {
            ProcessInstance processInstance = ksession.startProcess("hello");
            this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
            this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Hello", "End"});
        });
        DataSetServiceImpl dataSetService = new DataSetServiceImpl(() -> this.xesDataSource);
        XESExportServiceImpl service = new XESExportServiceImpl();
        service.setDataSetService((DataSetService)dataSetService);
        String xml = service.export(XESProcessFilter.builder().withProcessId("hello").withAllNodeTypes().build());
        XESLogMarshaller marshaller = new XESLogMarshaller();
        LogType log = marshaller.unmarshall(xml);
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((long)4L, (long)log.getExtension().size());
        Assert.assertEquals((long)3L, (long)log.getStringOrDateOrInt().size());
        Assert.assertEquals((long)2L, (long)log.getGlobal().size());
        Assert.assertEquals((long)4L, (long)log.getClassifier().size());
        Assert.assertEquals((long)instances, (long)log.getTrace().size());
        IntStream.range(0, instances).forEach(i -> Assert.assertEquals((long)6L, (long)((TraceType)log.getTrace().get(i)).getEvent().size()));
    }

    @Test
    public void testHelloProcessWithFilters() throws Exception {
        this.createRuntimeManager(new String[]{"hello.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        int instances = 5;
        IntStream.range(0, instances).forEach(i -> {
            ProcessInstance processInstance = ksession.startProcess("hello");
            this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
            this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Hello", "End"});
        });
        DataSetServiceImpl dataSetService = new DataSetServiceImpl(() -> this.xesDataSource);
        XESExportServiceImpl service = new XESExportServiceImpl();
        service.setDataSetService((DataSetService)dataSetService);
        XESProcessFilter filter = XESProcessFilter.builder().withProcessId("hello").withProcessVersion("1.0").withStatus(Arrays.asList(2)).withNodeInstanceLogType(Integer.valueOf(1)).build();
        String xml = service.export(filter);
        XESLogMarshaller marshaller = new XESLogMarshaller();
        LogType log = marshaller.unmarshall(xml);
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((long)4L, (long)log.getExtension().size());
        Assert.assertEquals((long)3L, (long)log.getStringOrDateOrInt().size());
        Assert.assertEquals((long)2L, (long)log.getGlobal().size());
        Assert.assertEquals((long)4L, (long)log.getClassifier().size());
        Assert.assertEquals((long)instances, (long)log.getTrace().size());
        IntStream.range(0, instances).forEach(i -> Assert.assertEquals((long)1L, (long)((TraceType)log.getTrace().get(i)).getEvent().size()));
    }
}

