/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.bytecode.MatchOffsetPair;
import org.gjt.jclasslib.bytecode.Opcode;
import org.gjt.jclasslib.bytecode.PaddedInstruction;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\b\u00a8\u0006\u001b"}, d2={"Lorg/gjt/jclasslib/bytecode/LookupSwitchInstruction;", "Lorg/gjt/jclasslib/bytecode/PaddedInstruction;", "opcode", "Lorg/gjt/jclasslib/bytecode/Opcode;", "(Lorg/gjt/jclasslib/bytecode/Opcode;)V", "defaultOffset", "", "getDefaultOffset", "()I", "setDefaultOffset", "(I)V", "matchOffsetPairs", "", "Lorg/gjt/jclasslib/bytecode/MatchOffsetPair;", "getMatchOffsetPairs", "()Ljava/util/List;", "setMatchOffsetPairs", "(Ljava/util/List;)V", "size", "getSize", "read", "", "input", "Lorg/gjt/jclasslib/io/ByteCodeInput;", "write", "output", "Lorg/gjt/jclasslib/io/ByteCodeOutput;", "data"})
public final class LookupSwitchInstruction
extends PaddedInstruction {
    private int defaultOffset;
    @NotNull
    private List<MatchOffsetPair> matchOffsetPairs;

    public final int getDefaultOffset() {
        return this.defaultOffset;
    }

    public final void setDefaultOffset(int n) {
        this.defaultOffset = n;
    }

    @NotNull
    public final List<MatchOffsetPair> getMatchOffsetPairs() {
        return this.matchOffsetPairs;
    }

    public final void setMatchOffsetPairs(@NotNull List<MatchOffsetPair> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.matchOffsetPairs = list;
    }

    @Override
    public int getSize() {
        return super.getSize() + 8 + 8 * this.matchOffsetPairs.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(@NotNull ByteCodeInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super.read(input);
        this.matchOffsetPairs.clear();
        this.defaultOffset = input.readInt();
        int numberOfPairs = input.readInt();
        int n = 0;
        int n2 = numberOfPairs;
        while (n < n2) {
            void i;
            int match = input.readInt();
            int offset = input.readInt();
            this.matchOffsetPairs.add(new MatchOffsetPair(match, offset));
            ++i;
        }
    }

    @Override
    public void write(@NotNull ByteCodeOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        output.writeInt(this.defaultOffset);
        int numberOfPairs = this.matchOffsetPairs.size();
        output.writeInt(numberOfPairs);
        for (MatchOffsetPair matchOffsetPair : this.matchOffsetPairs) {
            output.writeInt(matchOffsetPair.getMatch());
            output.writeInt(matchOffsetPair.getOffset());
        }
    }

    public LookupSwitchInstruction(@NotNull Opcode opcode) {
        Intrinsics.checkNotNullParameter((Object)opcode, (String)"opcode");
        super(opcode);
        this.matchOffsetPairs = new ArrayList();
    }
}

