/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.bytecode.Instruction;
import org.gjt.jclasslib.bytecode.Opcode;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/gjt/jclasslib/bytecode/PaddedInstruction;", "Lorg/gjt/jclasslib/bytecode/Instruction;", "opcode", "Lorg/gjt/jclasslib/bytecode/Opcode;", "(Lorg/gjt/jclasslib/bytecode/Opcode;)V", "getPaddedSize", "", "offset", "paddingBytes", "bytesCount", "read", "", "input", "Lorg/gjt/jclasslib/io/ByteCodeInput;", "write", "output", "Lorg/gjt/jclasslib/io/ByteCodeOutput;", "data"})
public class PaddedInstruction
extends Instruction {
    @Override
    public int getPaddedSize(int offset) {
        return this.getSize() + this.paddingBytes(offset + 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(@NotNull ByteCodeInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super.read(input);
        int bytesToRead = this.paddingBytes(input.getBytesRead());
        int n = 0;
        int n2 = bytesToRead;
        while (n < n2) {
            void i;
            input.readByte();
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull ByteCodeOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        int bytesToWrite = this.paddingBytes(output.getBytesWritten());
        int n = 0;
        int n2 = bytesToWrite;
        while (n < n2) {
            void i;
            output.writeByte(0);
            ++i;
        }
    }

    private final int paddingBytes(int bytesCount) {
        int bytesToPad = 4 - bytesCount % 4;
        return bytesToPad == 4 ? 0 : bytesToPad;
    }

    public PaddedInstruction(@NotNull Opcode opcode) {
        Intrinsics.checkNotNullParameter((Object)opcode, (String)"opcode");
        super(opcode);
    }
}

