/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.io;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0004\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0004\u001a1\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00042!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\f0\u000e\u001aF\u0010\u0012\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u000426\u0010\r\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\f0\u0013\u001a\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0004\u001a\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"classFileSuffix", "", "modulesRootsCache", "", "Ljava/io/File;", "Ljava/nio/file/Path;", "findClassInJrt", "className", "jreHome", "findClassWithModuleNameInJrt", "moduleNameAndClassName", "forEachClassInJrt", "", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "path", "forEachClassNameInJrt", "Lkotlin/Function2;", "moduleName", "getJrtInputStream", "Ljava/io/InputStream;", "fileName", "getModulesRoot", "data"})
public final class JimageKt {
    private static final Map<File, Path> modulesRootsCache;
    private static final String classFileSuffix = ".class";

    @NotNull
    public static final InputStream getJrtInputStream(@NotNull String fileName, @NotNull File jreHome) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)jreHome, (String)"jreHome");
        InputStream inputStream = Files.newInputStream(JimageKt.getModulesRoot(jreHome).resolve(fileName), new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"Files.newInputStream(get\u2026eHome).resolve(fileName))");
        return inputStream;
    }

    @Nullable
    public static final Path findClassWithModuleNameInJrt(@NotNull String moduleNameAndClassName, @NotNull File jreHome) {
        Intrinsics.checkNotNullParameter((Object)moduleNameAndClassName, (String)"moduleNameAndClassName");
        Intrinsics.checkNotNullParameter((Object)jreHome, (String)"jreHome");
        return JimageKt.getModulesRoot(jreHome).resolve(moduleNameAndClassName + classFileSuffix);
    }

    @Nullable
    public static final Path findClassInJrt(@NotNull String className, @NotNull File jreHome) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)jreHome, (String)"jreHome");
        String fileName = StringsKt.replace$default((String)className, (char)'.', (char)'/', (boolean)false, (int)4, null) + classFileSuffix;
        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(JimageKt.getModulesRoot(jreHome));
        Intrinsics.checkNotNullExpressionValue(directoryStream, (String)"Files.newDirectoryStream(getModulesRoot(jreHome))");
        Iterable $this$forEach$iv = directoryStream;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path module = (Path)element$iv;
            boolean bl = false;
            Path path = module.resolve(fileName);
            if (!Files.exists(path, new LinkOption[0])) continue;
            return path;
        }
        return null;
    }

    public static final void forEachClassInJrt(@NotNull File jreHome, @NotNull Function1<? super Path, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)jreHome, (String)"jreHome");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Files.walk(JimageKt.getModulesRoot(jreHome), new FileVisitOption[0]).forEach(new Consumer<Path>(block){
            final /* synthetic */ Function1 $block;

            public final void accept(Path path) {
                Path path2 = path;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                if (path2.getNameCount() > 2 && !Files.isDirectory(path, new LinkOption[0])) {
                    String string = ((Object)path).toString();
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    if (StringsKt.endsWith$default((String)string3, (String)".class", (boolean)false, (int)2, null)) {
                        this.$block.invoke((Object)path);
                    }
                }
            }
            {
                this.$block = function1;
            }
        });
    }

    public static final void forEachClassNameInJrt(@NotNull File jreHome, @NotNull Function2<? super String, ? super String, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)jreHome, (String)"jreHome");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        JimageKt.forEachClassInJrt(jreHome, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(block){
            final /* synthetic */ Function2 $block;

            public final void invoke(@NotNull Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                this.$block.invoke((Object)((Object)path.getName(1)).toString(), (Object)((Object)path.subpath(2, path.getNameCount())).toString());
            }
            {
                this.$block = function2;
                super(1);
            }
        }));
    }

    private static final Path getModulesRoot(File jreHome) {
        Path path;
        Map<File, Path> $this$getOrPut$iv = modulesRootsCache;
        boolean $i$f$getOrPut = false;
        Path value$iv = $this$getOrPut$iv.get(jreHome);
        if (value$iv == null) {
            boolean bl = false;
            URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(jreHome, "lib/jrt-fs.jar").toURI().toURL()});
            Path path2 = FileSystems.newFileSystem(new URI("jrt:/"), MapsKt.emptyMap(), (ClassLoader)classLoader).getPath("/modules", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"FileSystems.newFileSyste\u2026ader).getPath(\"/modules\")");
            Path answer$iv = path2;
            $this$getOrPut$iv.put(jreHome, answer$iv);
            path = answer$iv;
        } else {
            path = value$iv;
        }
        return path;
    }

    static {
        boolean bl = false;
        modulesRootsCache = new LinkedHashMap();
    }
}

