/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.Package;
import org.gjt.jclasslib.structures.attributes.AnnotationDefaultAttribute;
import org.gjt.jclasslib.structures.attributes.BootstrapMethodsAttribute;
import org.gjt.jclasslib.structures.attributes.CodeAttribute;
import org.gjt.jclasslib.structures.attributes.ConstantValueAttribute;
import org.gjt.jclasslib.structures.attributes.DeprecatedAttribute;
import org.gjt.jclasslib.structures.attributes.EnclosingMethodAttribute;
import org.gjt.jclasslib.structures.attributes.ExceptionsAttribute;
import org.gjt.jclasslib.structures.attributes.InnerClassesAttribute;
import org.gjt.jclasslib.structures.attributes.LineNumberTableAttribute;
import org.gjt.jclasslib.structures.attributes.LocalVariableTableAttribute;
import org.gjt.jclasslib.structures.attributes.LocalVariableTypeTableAttribute;
import org.gjt.jclasslib.structures.attributes.MethodParametersAttribute;
import org.gjt.jclasslib.structures.attributes.ModuleAttribute;
import org.gjt.jclasslib.structures.attributes.ModuleHashesAttribute;
import org.gjt.jclasslib.structures.attributes.ModuleMainClassAttribute;
import org.gjt.jclasslib.structures.attributes.ModulePackagesAttribute;
import org.gjt.jclasslib.structures.attributes.ModuleResolutionAttribute;
import org.gjt.jclasslib.structures.attributes.ModuleTargetAttribute;
import org.gjt.jclasslib.structures.attributes.NestHostAttribute;
import org.gjt.jclasslib.structures.attributes.NestMembersAttribute;
import org.gjt.jclasslib.structures.attributes.PermittedSubclassesAttribute;
import org.gjt.jclasslib.structures.attributes.RecordAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeInvisibleAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeInvisibleParameterAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeInvisibleTypeAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeVisibleAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeVisibleParameterAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeVisibleTypeAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.SignatureAttribute;
import org.gjt.jclasslib.structures.attributes.SourceDebugExtensionAttribute;
import org.gjt.jclasslib.structures.attributes.SourceFileAttribute;
import org.gjt.jclasslib.structures.attributes.StackMapTableAttribute;
import org.gjt.jclasslib.structures.attributes.SyntheticAttribute;
import org.gjt.jclasslib.structures.attributes.UnknownAttribute;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J'\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\u00020\u001b*\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u001c\u001a\u00020\u001b*\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/gjt/jclasslib/structures/AttributeContainer;", "", "attributes", "", "Lorg/gjt/jclasslib/structures/AttributeInfo;", "getAttributes", "()[Lorg/gjt/jclasslib/structures/AttributeInfo;", "setAttributes", "([Lorg/gjt/jclasslib/structures/AttributeInfo;)V", "totalAttributesLength", "", "getTotalAttributesLength", "()I", "create", "attributeLength", "attributeName", "", "input", "Ljava/io/DataInput;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "findAttribute", "T", "attributeClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lorg/gjt/jclasslib/structures/AttributeInfo;", "readAttributes", "", "writeAttributes", "output", "Ljava/io/DataOutput;", "data"})
public interface AttributeContainer {
    @NotNull
    public AttributeInfo[] getAttributes();

    public void setAttributes(@NotNull AttributeInfo[] var1);

    @Nullable
    public <T extends AttributeInfo> T findAttribute(@NotNull Class<T> var1);

    public int getTotalAttributesLength();

    public void readAttributes(@NotNull AttributeContainer var1, @NotNull DataInput var2, @NotNull ClassFile var3);

    public void writeAttributes(@NotNull AttributeContainer var1, @NotNull DataOutput var2);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static <T extends AttributeInfo> T findAttribute(@NotNull AttributeContainer $this, @NotNull Class<T> attributeClass) {
            Intrinsics.checkNotNullParameter(attributeClass, (String)"attributeClass");
            return (T)((AttributeInfo)CollectionsKt.firstOrNull((List)ArraysKt.filterIsInstance((Object[])$this.getAttributes(), attributeClass)));
        }

        /*
         * WARNING - void declaration
         */
        public static int getTotalAttributesLength(@NotNull AttributeContainer $this) {
            void var3_3;
            AttributeInfo[] $this$sumBy$iv = $this.getAttributes();
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            AttributeInfo[] attributeInfoArray = $this$sumBy$iv;
            int n = attributeInfoArray.length;
            for (int i = 0; i < n; ++i) {
                void it;
                AttributeInfo element$iv;
                AttributeInfo attributeInfo = element$iv = attributeInfoArray[i];
                int n2 = sum$iv;
                boolean bl = false;
                int n3 = it.getAttributeLength();
                sum$iv = n2 + n3;
            }
            return (int)var3_3;
        }

        public static void readAttributes(@NotNull AttributeContainer $this, @NotNull AttributeContainer $this$readAttributes, @NotNull DataInput input, @NotNull ClassFile classFile) {
            Intrinsics.checkNotNullParameter((Object)$this$readAttributes, (String)"$this$readAttributes");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
            int attributesCount = input.readUnsignedShort();
            if (Boolean.getBoolean("jclasslib.io.skipAttributes")) {
                AttributeInfo[] attributeInfoArray;
                AttributeContainer attributeContainer = $this$readAttributes;
                AttributeInfo[] attributeInfoArray2 = new AttributeInfo[attributesCount];
                int n = 0;
                while (n < attributesCount) {
                    AttributeInfo attributeInfo;
                    int n2 = n;
                    int n3 = n++;
                    attributeInfoArray = attributeInfoArray2;
                    boolean bl = false;
                    input.skipBytes(2);
                    int attributeLength = input.readInt();
                    input.skipBytes(attributeLength);
                    attributeInfoArray[n3] = attributeInfo = (AttributeInfo)new UnknownAttribute(attributeLength, classFile);
                }
                attributeInfoArray = attributeInfoArray2;
                attributeContainer.setAttributes(attributeInfoArray);
            } else {
                AttributeInfo[] attributeInfoArray;
                AttributeContainer attributeContainer = $this$readAttributes;
                AttributeInfo[] attributeInfoArray3 = new AttributeInfo[attributesCount];
                for (int i = 0; i < attributesCount; ++i) {
                    AttributeInfo attributeInfo;
                    int it = i;
                    int n = i;
                    attributeInfoArray = attributeInfoArray3;
                    boolean bl = false;
                    int attributeNameIndex = input.readUnsignedShort();
                    int attributeLength = input.readInt();
                    ConstantUtf8Info cpInfoName = classFile.getConstantPoolUtf8Entry(attributeNameIndex);
                    AttributeInfo attributeInfo2 = DefaultImpls.create($this$readAttributes, attributeLength, cpInfoName.getString(), input, classFile);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    AttributeInfo $this$apply = attributeInfo2;
                    boolean bl4 = false;
                    $this$apply.setAttributeNameIndex(attributeNameIndex);
                    if (!($this$apply instanceof AnnotationDefaultAttribute)) {
                        $this$apply.read(input);
                    }
                    attributeInfoArray[n] = attributeInfo = attributeInfo2;
                }
                attributeInfoArray = attributeInfoArray3;
                attributeContainer.setAttributes(attributeInfoArray);
                if (Package.isDebug()) {
                    Package.debug("read " + attributesCount + " attributes", input);
                }
            }
        }

        private static AttributeInfo create(AttributeContainer $this, int attributeLength, String attributeName, DataInput input, ClassFile classFile) {
            AttributeInfo attributeInfo;
            switch (attributeName) {
                case "ConstantValue": {
                    attributeInfo = new ConstantValueAttribute(classFile);
                    break;
                }
                case "Code": {
                    attributeInfo = new CodeAttribute(classFile);
                    break;
                }
                case "Exceptions": {
                    attributeInfo = new ExceptionsAttribute(classFile);
                    break;
                }
                case "InnerClasses": {
                    attributeInfo = new InnerClassesAttribute(classFile);
                    break;
                }
                case "SourceDebugExtension": {
                    attributeInfo = new SourceDebugExtensionAttribute(attributeLength, classFile);
                    break;
                }
                case "Synthetic": {
                    attributeInfo = new SyntheticAttribute(classFile);
                    break;
                }
                case "SourceFile": {
                    attributeInfo = new SourceFileAttribute(classFile);
                    break;
                }
                case "LineNumberTable": {
                    attributeInfo = new LineNumberTableAttribute(classFile);
                    break;
                }
                case "LocalVariableTable": {
                    attributeInfo = new LocalVariableTableAttribute(classFile);
                    break;
                }
                case "Deprecated": {
                    attributeInfo = new DeprecatedAttribute(classFile);
                    break;
                }
                case "EnclosingMethod": {
                    attributeInfo = new EnclosingMethodAttribute(classFile);
                    break;
                }
                case "Signature": {
                    attributeInfo = new SignatureAttribute(classFile);
                    break;
                }
                case "LocalVariableTypeTable": {
                    attributeInfo = new LocalVariableTypeTableAttribute(classFile);
                    break;
                }
                case "RuntimeVisibleAnnotations": {
                    attributeInfo = new RuntimeVisibleAnnotationsAttribute(classFile);
                    break;
                }
                case "RuntimeInvisibleAnnotations": {
                    attributeInfo = new RuntimeInvisibleAnnotationsAttribute(classFile);
                    break;
                }
                case "RuntimeVisibleParameterAnnotations": {
                    attributeInfo = new RuntimeVisibleParameterAnnotationsAttribute(classFile);
                    break;
                }
                case "RuntimeInvisibleParameterAnnotations": {
                    attributeInfo = new RuntimeInvisibleParameterAnnotationsAttribute(classFile);
                    break;
                }
                case "RuntimeVisibleTypeAnnotations": {
                    attributeInfo = new RuntimeVisibleTypeAnnotationsAttribute(classFile);
                    break;
                }
                case "RuntimeInvisibleTypeAnnotations": {
                    attributeInfo = new RuntimeInvisibleTypeAnnotationsAttribute(classFile);
                    break;
                }
                case "AnnotationDefault": {
                    attributeInfo = new AnnotationDefaultAttribute(classFile, input);
                    break;
                }
                case "BootstrapMethods": {
                    attributeInfo = new BootstrapMethodsAttribute(classFile);
                    break;
                }
                case "StackMapTable": {
                    attributeInfo = new StackMapTableAttribute(classFile);
                    break;
                }
                case "MethodParameters": {
                    attributeInfo = new MethodParametersAttribute(classFile);
                    break;
                }
                case "Module": {
                    attributeInfo = new ModuleAttribute(classFile);
                    break;
                }
                case "ModulePackages": {
                    attributeInfo = new ModulePackagesAttribute(classFile);
                    break;
                }
                case "ModuleMainClass": {
                    attributeInfo = new ModuleMainClassAttribute(classFile);
                    break;
                }
                case "ModuleTarget": {
                    attributeInfo = new ModuleTargetAttribute(classFile);
                    break;
                }
                case "ModuleHashes": {
                    attributeInfo = new ModuleHashesAttribute(classFile);
                    break;
                }
                case "ModuleResolution": {
                    attributeInfo = new ModuleResolutionAttribute(classFile);
                    break;
                }
                case "NestHost": {
                    attributeInfo = new NestHostAttribute(classFile);
                    break;
                }
                case "NestMembers": {
                    attributeInfo = new NestMembersAttribute(classFile);
                    break;
                }
                case "Record": {
                    attributeInfo = new RecordAttribute(classFile);
                    break;
                }
                case "PermittedSubclasses": {
                    attributeInfo = new PermittedSubclassesAttribute(classFile);
                    break;
                }
                default: {
                    attributeInfo = new UnknownAttribute(attributeLength, classFile);
                }
            }
            return attributeInfo;
        }

        public static void writeAttributes(@NotNull AttributeContainer $this, @NotNull AttributeContainer $this$writeAttributes, @NotNull DataOutput output) {
            Intrinsics.checkNotNullParameter((Object)$this$writeAttributes, (String)"$this$writeAttributes");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            int attributesCount = $this$writeAttributes.getAttributes().length;
            output.writeShort(attributesCount);
            AttributeInfo[] $this$forEach$iv = $this$writeAttributes.getAttributes();
            boolean $i$f$forEach = false;
            AttributeInfo[] attributeInfoArray = $this$forEach$iv;
            int n = attributeInfoArray.length;
            for (int i = 0; i < n; ++i) {
                AttributeInfo element$iv;
                AttributeInfo it = element$iv = attributeInfoArray[i];
                boolean bl = false;
                output.writeShort(it.getAttributeNameIndex());
                output.writeInt(it.getAttributeLength());
                it.write(output);
            }
            if (Package.isDebug()) {
                Package.debug("wrote " + attributesCount + " attributes", output);
            }
        }
    }
}

