/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.gjt.jclasslib.structures.AccessFlag;
import org.gjt.jclasslib.structures.AttributeContainer;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.Constant;
import org.gjt.jclasslib.structures.ConstantType;
import org.gjt.jclasslib.structures.FieldInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.MethodInfo;
import org.gjt.jclasslib.structures.Package;
import org.gjt.jclasslib.structures.Structure;
import org.gjt.jclasslib.structures.constants.ConstantPlaceholder;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 |2\u00020\u00012\u00020\u0002:\u0001|B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010K\u001a\u00020L2\u0006\u00100\u001a\u00020\u0005H\u0002J\u0010\u0010M\u001a\u00020L2\u0006\u0010N\u001a\u00020\u0005H\u0002J\u0019\u0010O\u001a\u00020L2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f\u00a2\u0006\u0002\u0010\u001bJ+\u0010Q\u001a\u0002HR\"\b\b\u0000\u0010R*\u00020\u00172\u0006\u0010N\u001a\u00020\u00052\f\u0010S\u001a\b\u0012\u0004\u0012\u0002HR0T\u00a2\u0006\u0002\u0010UJ\u000e\u0010V\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u0005J\u000e\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020\u0017J\u000e\u0010Y\u001a\u00020Z2\u0006\u0010N\u001a\u00020\u0005J\u0018\u0010[\u001a\u0004\u0018\u00010\"2\u0006\u0010\\\u001a\u00020\u000b2\u0006\u0010]\u001a\u00020\u000bJ\u0016\u0010^\u001a\u00020\u00052\u0006\u0010\\\u001a\u00020\u000b2\u0006\u0010]\u001a\u00020\u000bJ\u0018\u0010_\u001a\u0004\u0018\u0001062\u0006\u0010\\\u001a\u00020\u000b2\u0006\u0010]\u001a\u00020\u000bJ\u0016\u0010`\u001a\u00020\u00052\u0006\u0010\\\u001a\u00020\u000b2\u0006\u0010]\u001a\u00020\u000bJ\u0010\u0010a\u001a\u00020L2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010d\u001a\u00020L2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010e\u001a\u00020L2\u0006\u0010b\u001a\u00020cH\u0014J\u0010\u0010f\u001a\u00020L2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010g\u001a\u00020L2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010h\u001a\u00020L2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010i\u001a\u00020L2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010j\u001a\u00020L2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010k\u001a\u00020L2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010l\u001a\u00020L2\u0006\u0010b\u001a\u00020cH\u0002J\u000e\u0010m\u001a\u00020L2\u0006\u0010N\u001a\u00020\u0005J\u000e\u0010n\u001a\u00020L2\u0006\u0010N\u001a\u00020\u0005J\u0010\u0010o\u001a\u00020L2\u0006\u0010p\u001a\u00020qH\u0002J\u0010\u0010r\u001a\u00020L2\u0006\u0010s\u001a\u00020qH\u0002J\u0010\u0010t\u001a\u00020L2\u0006\u0010p\u001a\u00020qH\u0014J\u0010\u0010u\u001a\u00020L2\u0006\u0010s\u001a\u00020qH\u0002J\u0010\u0010v\u001a\u00020L2\u0006\u0010s\u001a\u00020qH\u0002J\u0010\u0010w\u001a\u00020L2\u0006\u0010s\u001a\u00020qH\u0002J\u0010\u0010x\u001a\u00020L2\u0006\u0010s\u001a\u00020qH\u0002J\u0010\u0010y\u001a\u00020L2\u0006\u0010p\u001a\u00020qH\u0002J\u0010\u0010z\u001a\u00020L2\u0006\u0010p\u001a\u00020qH\u0002J\u0010\u0010{\u001a\u00020L2\u0006\u0010s\u001a\u00020qH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R2\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00050\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\rR\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010'\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010(\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\rR\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0007\"\u0004\b2\u0010\tR\u0011\u00103\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\rR\"\u00105\u001a\b\u0012\u0004\u0012\u0002060\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010;\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010<\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0007\"\u0004\b>\u0010\tR\u0011\u0010?\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010\rR\u001a\u0010A\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0007\"\u0004\bC\u0010\tR\u0011\u0010D\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010\rR\u001a\u0010F\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\u0007\"\u0004\bH\u0010\tR\u0011\u0010I\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\r\u00a8\u0006}"}, d2={"Lorg/gjt/jclasslib/structures/ClassFile;", "Lorg/gjt/jclasslib/structures/Structure;", "Lorg/gjt/jclasslib/structures/AttributeContainer;", "()V", "accessFlags", "", "getAccessFlags", "()I", "setAccessFlags", "(I)V", "accessFlagsVerbose", "", "getAccessFlagsVerbose", "()Ljava/lang/String;", "attributes", "", "Lorg/gjt/jclasslib/structures/AttributeInfo;", "getAttributes", "()[Lorg/gjt/jclasslib/structures/AttributeInfo;", "setAttributes", "([Lorg/gjt/jclasslib/structures/AttributeInfo;)V", "[Lorg/gjt/jclasslib/structures/AttributeInfo;", "constantPool", "Lorg/gjt/jclasslib/structures/Constant;", "getConstantPool", "()[Lorg/gjt/jclasslib/structures/Constant;", "setConstantPool", "([Lorg/gjt/jclasslib/structures/Constant;)V", "[Lorg/gjt/jclasslib/structures/Constant;", "constantPoolEntryToIndex", "Ljava/util/HashMap;", "debugInfo", "getDebugInfo", "fields", "Lorg/gjt/jclasslib/structures/FieldInfo;", "getFields", "()[Lorg/gjt/jclasslib/structures/FieldInfo;", "setFields", "([Lorg/gjt/jclasslib/structures/FieldInfo;)V", "[Lorg/gjt/jclasslib/structures/FieldInfo;", "formattedAccessFlags", "getFormattedAccessFlags", "interfaces", "", "getInterfaces", "()[I", "setInterfaces", "([I)V", "majorVersion", "getMajorVersion", "setMajorVersion", "majorVersionVerbose", "getMajorVersionVerbose", "methods", "Lorg/gjt/jclasslib/structures/MethodInfo;", "getMethods", "()[Lorg/gjt/jclasslib/structures/MethodInfo;", "setMethods", "([Lorg/gjt/jclasslib/structures/MethodInfo;)V", "[Lorg/gjt/jclasslib/structures/MethodInfo;", "minorVersion", "getMinorVersion", "setMinorVersion", "simpleClassName", "getSimpleClassName", "superClass", "getSuperClass", "setSuperClass", "superClassName", "getSuperClassName", "thisClass", "getThisClass", "setThisClass", "thisClassName", "getThisClassName", "checkMajorVersion", "", "checkValidConstantPoolIndex", "index", "enlargeConstantPool", "enlargedConstantPool", "getConstantPoolEntry", "T", "entryClass", "Ljava/lang/Class;", "(ILjava/lang/Class;)Lorg/gjt/jclasslib/structures/Constant;", "getConstantPoolEntryName", "getConstantPoolIndex", "constant", "getConstantPoolUtf8Entry", "Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "getField", "name", "descriptor", "getFieldIndex", "getMethod", "getMethodIndex", "readAccessFlags", "input", "Ljava/io/DataInput;", "readConstantPool", "readData", "readFields", "readInterfaces", "readMagicNumber", "readMethods", "readSuperClass", "readThisClass", "readVersion", "registerConstantPoolEntry", "unregisterConstantPoolEntry", "writeAccessFlags", "output", "Ljava/io/DataOutput;", "writeConstantPool", "out", "writeData", "writeFields", "writeInterfaces", "writeMagicNumber", "writeMethods", "writeSuperClass", "writeThisClass", "writeVersion", "Companion", "data"})
public final class ClassFile
extends Structure
implements AttributeContainer {
    private int minorVersion;
    private int majorVersion;
    @NotNull
    private Constant[] constantPool;
    private final HashMap<Constant, Integer> constantPoolEntryToIndex;
    private int accessFlags;
    private int thisClass;
    private int superClass;
    @NotNull
    private int[] interfaces;
    @NotNull
    private FieldInfo[] fields;
    @NotNull
    private MethodInfo[] methods;
    @NotNull
    private AttributeInfo[] attributes;
    private static final int MAGIC_NUMBER = -889275714;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getMinorVersion() {
        return this.minorVersion;
    }

    public final void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public final int getMajorVersion() {
        return this.majorVersion;
    }

    public final void setMajorVersion(int n) {
        this.majorVersion = n;
    }

    @NotNull
    public final Constant[] getConstantPool() {
        return this.constantPool;
    }

    /*
     * WARNING - void declaration
     */
    public final void setConstantPool(@NotNull Constant[] constantPool) {
        Intrinsics.checkNotNullParameter((Object)constantPool, (String)"constantPool");
        this.constantPool = constantPool;
        Constant[] $this$forEachIndexed$iv = constantPool;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Constant item$iv : $this$forEachIndexed$iv) {
            void cpInfo;
            int n = index$iv++;
            Constant constant = item$iv;
            int i = n;
            boolean bl = false;
            ((Map)this.constantPoolEntryToIndex).put(cpInfo, i);
        }
    }

    public final int getAccessFlags() {
        return this.accessFlags;
    }

    public final void setAccessFlags(int n) {
        this.accessFlags = n;
    }

    public final int getThisClass() {
        return this.thisClass;
    }

    public final void setThisClass(int n) {
        this.thisClass = n;
    }

    public final int getSuperClass() {
        return this.superClass;
    }

    public final void setSuperClass(int n) {
        this.superClass = n;
    }

    @NotNull
    public final int[] getInterfaces() {
        return this.interfaces;
    }

    public final void setInterfaces(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.interfaces = nArray;
    }

    @NotNull
    public final FieldInfo[] getFields() {
        return this.fields;
    }

    public final void setFields(@NotNull FieldInfo[] fieldInfoArray) {
        Intrinsics.checkNotNullParameter((Object)fieldInfoArray, (String)"<set-?>");
        this.fields = fieldInfoArray;
    }

    @NotNull
    public final MethodInfo[] getMethods() {
        return this.methods;
    }

    public final void setMethods(@NotNull MethodInfo[] methodInfoArray) {
        Intrinsics.checkNotNullParameter((Object)methodInfoArray, (String)"<set-?>");
        this.methods = methodInfoArray;
    }

    @Override
    @NotNull
    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull AttributeInfo[] attributeInfoArray) {
        Intrinsics.checkNotNullParameter((Object)attributeInfoArray, (String)"<set-?>");
        this.attributes = attributeInfoArray;
    }

    @NotNull
    public final String getMajorVersionVerbose() {
        String string;
        switch (this.majorVersion) {
            case 45: {
                string = "1.1";
                break;
            }
            case 46: {
                string = "1.2";
                break;
            }
            case 47: {
                string = "1.3";
                break;
            }
            case 48: {
                string = "1.4";
                break;
            }
            case 49: {
                string = "1.5";
                break;
            }
            case 50: {
                string = "1.6";
                break;
            }
            case 51: {
                string = "1.7";
                break;
            }
            case 52: {
                string = "1.8";
                break;
            }
            case 53: {
                string = "9";
                break;
            }
            case 54: {
                string = "10";
                break;
            }
            case 55: {
                string = "11";
                break;
            }
            case 56: {
                string = "12";
                break;
            }
            case 57: {
                string = "13";
                break;
            }
            case 58: {
                string = "14";
                break;
            }
            case 59: {
                string = "15";
                break;
            }
            case 60: {
                string = "16";
                break;
            }
            case 61: {
                string = "17";
                break;
            }
            default: {
                string = "unknown value " + this.majorVersion;
            }
        }
        return string;
    }

    public final int getConstantPoolIndex(@NotNull Constant constant) {
        Intrinsics.checkNotNullParameter((Object)constant, (String)"constant");
        Integer n = this.constantPoolEntryToIndex.get(constant);
        return n != null ? n : -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void enlargeConstantPool(@NotNull Constant[] enlargedConstantPool) {
        Intrinsics.checkNotNullParameter((Object)enlargedConstantPool, (String)"enlargedConstantPool");
        int n = this.constantPool.length;
        int n2 = enlargedConstantPool.length;
        while (n < n2) {
            void i;
            ((Map)this.constantPoolEntryToIndex).put(enlargedConstantPool[i], (int)i);
            ++i;
        }
        this.setConstantPool(enlargedConstantPool);
    }

    public final void registerConstantPoolEntry(int index) {
        ((Map)this.constantPoolEntryToIndex).put(this.constantPool[index], index);
    }

    public final void unregisterConstantPoolEntry(int index) {
        this.constantPoolEntryToIndex.remove(this.constantPool[index]);
    }

    @NotNull
    public final String getThisClassName() throws InvalidByteCodeException {
        return this.getConstantPoolEntryName(this.thisClass);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getSimpleClassName() {
        String string;
        block2: {
            void var1_1;
            String $this$takeLastWhile$iv = this.getThisClassName();
            boolean $i$f$takeLastWhile = false;
            int n = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv);
            boolean bl = false;
            while (n >= 0) {
                void index$iv;
                char it = $this$takeLastWhile$iv.charAt((int)index$iv);
                boolean bl2 = false;
                if (!(it != '/')) {
                    String string2 = $this$takeLastWhile$iv;
                    void var6_7 = index$iv + true;
                    boolean bl3 = false;
                    String string3 = string2.substring((int)var6_7);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    break block2;
                }
                --index$iv;
            }
            string = var1_1;
        }
        return string;
    }

    @NotNull
    public final String getSuperClassName() throws InvalidByteCodeException {
        return this.getConstantPoolEntryName(this.superClass);
    }

    @NotNull
    public final String getFormattedAccessFlags() {
        return this.formatAccessFlags(this.accessFlags);
    }

    @NotNull
    public final String getAccessFlagsVerbose() {
        return this.formatAccessFlagsVerbose(AccessFlag.Companion.getCLASS_ACCESS_FLAGS(), this.accessFlags);
    }

    @NotNull
    public final ConstantUtf8Info getConstantPoolUtf8Entry(int index) throws InvalidByteCodeException {
        return this.getConstantPoolEntry(index, ConstantUtf8Info.class);
    }

    @NotNull
    public final <T extends Constant> T getConstantPoolEntry(int index, @NotNull Class<T> entryClass) throws InvalidByteCodeException {
        Intrinsics.checkNotNullParameter(entryClass, (String)"entryClass");
        this.checkValidConstantPoolIndex(index);
        Constant cpInfo = this.constantPool[index];
        if (!entryClass.isAssignableFrom(cpInfo.getClass())) {
            throw (Throwable)new InvalidByteCodeException("constant pool entry at " + index + " of class " + cpInfo.getClass().getName() + " is not assignable to " + entryClass.getName());
        }
        T t = entryClass.cast(cpInfo);
        Intrinsics.checkNotNullExpressionValue(t, (String)"entryClass.cast(cpInfo)");
        return (T)((Constant)t);
    }

    @NotNull
    public final String getConstantPoolEntryName(int index) throws InvalidByteCodeException {
        this.checkValidConstantPoolIndex(index);
        return this.constantPool[index].getVerbose();
    }

    /*
     * WARNING - void declaration
     */
    public final int getFieldIndex(@NotNull String name, @NotNull String descriptor) throws InvalidByteCodeException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        FieldInfo[] $this$forEachIndexed$iv = this.fields;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (FieldInfo item$iv : $this$forEachIndexed$iv) {
            void fieldInfo;
            int n = index$iv++;
            FieldInfo fieldInfo2 = item$iv;
            int i = n;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)fieldInfo.getName(), (Object)name) || !Intrinsics.areEqual((Object)fieldInfo.getDescriptor(), (Object)descriptor)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public final FieldInfo getField(@NotNull String name, @NotNull String descriptor) throws InvalidByteCodeException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int index = this.getFieldIndex(name, descriptor);
        return index < 0 ? null : this.fields[index];
    }

    /*
     * WARNING - void declaration
     */
    public final int getMethodIndex(@NotNull String name, @NotNull String descriptor) throws InvalidByteCodeException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        MethodInfo[] $this$forEachIndexed$iv = this.methods;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (MethodInfo item$iv : $this$forEachIndexed$iv) {
            void methodInfo;
            int n = index$iv++;
            MethodInfo methodInfo2 = item$iv;
            int i = n;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)methodInfo.getName(), (Object)name) || !Intrinsics.areEqual((Object)methodInfo.getDescriptor(), (Object)descriptor)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public final MethodInfo getMethod(@NotNull String name, @NotNull String descriptor) throws InvalidByteCodeException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int index = this.getMethodIndex(name, descriptor);
        return index < 0 ? null : this.methods[index];
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.readMagicNumber(input);
        this.readVersion(input);
        this.readConstantPool(input);
        this.readAccessFlags(input);
        this.readThisClass(input);
        this.readSuperClass(input);
        this.readInterfaces(input);
        this.readFields(input);
        this.readMethods(input);
        this.readAttributes(this, input, this);
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.writeMagicNumber(output);
        this.writeVersion(output);
        this.writeConstantPool(output);
        this.writeAccessFlags(output);
        this.writeThisClass(output);
        this.writeSuperClass(output);
        this.writeInterfaces(output);
        this.writeFields(output);
        this.writeMethods(output);
        this.writeAttributes(this, output);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "";
    }

    private final void checkValidConstantPoolIndex(int index) {
        if (index < 1 || index >= this.constantPool.length) {
            throw (Throwable)new InvalidByteCodeException("Constant pool index " + index + " is out of bounds [0, " + (this.constantPool.length - 1) + ']');
        }
    }

    private final void readMagicNumber(DataInput input) {
        int magicNumber = input.readInt();
        if (magicNumber != -889275714) {
            throw (Throwable)new InvalidByteCodeException("Invalid magic number " + Package.getHex(magicNumber) + " instead of " + Package.getHex(-889275714));
        }
        if (Package.isDebug()) {
            Package.debug("read magic number", input);
        }
    }

    private final void writeMagicNumber(DataOutput out) {
        out.writeInt(-889275714);
        if (Package.isDebug()) {
            Package.debug("wrote magic number", out);
        }
    }

    private final void readVersion(DataInput input) {
        this.minorVersion = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read minor version " + this.minorVersion, input);
        }
        this.majorVersion = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read major version " + this.majorVersion, input);
        }
        this.checkMajorVersion(this.majorVersion);
    }

    private final void writeVersion(DataOutput out) {
        out.writeShort(this.minorVersion);
        if (Package.isDebug()) {
            Package.debug("wrote minor version " + this.minorVersion, out);
        }
        out.writeShort(this.majorVersion);
        if (Package.isDebug()) {
            Package.debug("wrote major version " + this.majorVersion, out);
        }
        this.checkMajorVersion(this.majorVersion);
    }

    /*
     * WARNING - void declaration
     */
    private final void readConstantPool(DataInput input) {
        Constant[] constantArray;
        this.constantPoolEntryToIndex.clear();
        int constantPoolCount = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read constant pool count " + constantPoolCount, input);
        }
        boolean placeholderIndex = false;
        ClassFile classFile = this;
        Constant[] constantArray2 = new Constant[constantPoolCount];
        for (int i = 0; i < constantPoolCount; ++i) {
            Constant constant;
            Constant constant2;
            void i2;
            int n = i;
            int n2 = i;
            constantArray = constantArray2;
            boolean bl = false;
            void var8_9 = i2;
            if (var8_9 == placeholderIndex) {
                constant2 = ConstantPlaceholder.INSTANCE;
            } else {
                if (Package.isDebug()) {
                    Package.debug("reading constant pool entry " + (int)i2, input);
                }
                ConstantType constantType = (ConstantType)ConstantType.Companion.getFromTag(input.readByte());
                Constant constant3 = constantType.read(this, input);
                boolean bl2 = false;
                boolean bl3 = false;
                Constant $this$apply = constant3;
                boolean bl4 = false;
                ((Map)this.constantPoolEntryToIndex).put($this$apply, (int)i2);
                int extraEntryCount = constantType.getExtraEntryCount();
                if (extraEntryCount > 0) {
                    placeholderIndex = i2 + extraEntryCount;
                }
                constant2 = constant3;
            }
            constantArray[n2] = constant = constant2;
        }
        constantArray = constantArray2;
        classFile.setConstantPool(constantArray);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeConstantPool(DataOutput out) {
        out.writeShort(this.constantPool.length);
        if (Package.isDebug()) {
            Package.debug("wrote constant pool count " + this.constantPool.length, out);
        }
        Constant[] $this$forEachIndexed$iv = this.constantPool;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Constant item$iv : $this$forEachIndexed$iv) {
            void cpInfo;
            int n = index$iv++;
            Constant constant = item$iv;
            int i = n;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)cpInfo, (Object)ConstantPlaceholder.INSTANCE) ^ true)) continue;
            if (Package.isDebug()) {
                Package.debug("writing constant pool entry " + i, out);
            }
            cpInfo.write(out);
        }
    }

    private final void readAccessFlags(DataInput input) {
        this.accessFlags = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read access flags " + this.getAccessFlagsVerbose(), input);
        }
    }

    private final void writeAccessFlags(DataOutput output) {
        output.writeShort(this.accessFlags);
        if (Package.isDebug()) {
            Package.debug("wrote access flags " + this.getAccessFlagsVerbose(), output);
        }
    }

    private final void readThisClass(DataInput input) {
        this.thisClass = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read this_class index " + this.thisClass, input);
        }
    }

    private final void writeThisClass(DataOutput output) {
        output.writeShort(this.thisClass);
        if (Package.isDebug()) {
            Package.debug("wrote this_class index " + this.thisClass, output);
        }
    }

    private final void readSuperClass(DataInput input) {
        this.superClass = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read super_class index " + this.superClass, input);
        }
    }

    private final void writeSuperClass(DataOutput output) {
        output.writeShort(this.superClass);
        if (Package.isDebug()) {
            Package.debug("wrote super_class index " + this.superClass, output);
        }
    }

    private final void readInterfaces(DataInput input) {
        int[] nArray;
        int interfacesCount = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read interfaces count " + interfacesCount, input);
        }
        ClassFile classFile = this;
        int[] nArray2 = new int[interfacesCount];
        for (int i = 0; i < interfacesCount; ++i) {
            int n;
            int n2 = i;
            int n3 = i;
            nArray = nArray2;
            boolean bl = false;
            int index = input.readUnsignedShort();
            if (Package.isDebug()) {
                Package.debug("read interface index " + index, input);
            }
            nArray[n3] = n = index;
        }
        nArray = nArray2;
        classFile.interfaces = nArray;
    }

    private final void writeInterfaces(DataOutput out) {
        int interfacesCount = this.interfaces.length;
        out.writeShort(interfacesCount);
        if (Package.isDebug()) {
            Package.debug("wrote interfaces count " + interfacesCount, out);
        }
        int[] $this$forEach$iv = this.interfaces;
        boolean $i$f$forEach = false;
        int[] nArray = $this$forEach$iv;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = nArray[i];
            boolean bl = false;
            out.writeShort(it);
            if (!Package.isDebug()) continue;
            Package.debug("wrote interface index " + it, out);
        }
    }

    private final void readFields(DataInput input) {
        FieldInfo[] fieldInfoArray;
        int fieldsCount = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read fields count " + fieldsCount, input);
        }
        ClassFile classFile = this;
        FieldInfo[] fieldInfoArray2 = new FieldInfo[fieldsCount];
        int n = 0;
        while (n < fieldsCount) {
            FieldInfo fieldInfo;
            int n2 = n;
            int n3 = n++;
            fieldInfoArray = fieldInfoArray2;
            boolean bl = false;
            FieldInfo fieldInfo2 = new FieldInfo(this);
            boolean bl2 = false;
            boolean bl3 = false;
            FieldInfo $this$apply = fieldInfo2;
            boolean bl4 = false;
            $this$apply.read(input);
            fieldInfoArray[n3] = fieldInfo = fieldInfo2;
        }
        fieldInfoArray = fieldInfoArray2;
        classFile.fields = fieldInfoArray;
    }

    private final void writeFields(DataOutput out) {
        int fieldsCount = this.fields.length;
        out.writeShort(fieldsCount);
        if (Package.isDebug()) {
            Package.debug("wrote fields count " + fieldsCount, out);
        }
        FieldInfo[] $this$forEach$iv = this.fields;
        boolean $i$f$forEach = false;
        FieldInfo[] fieldInfoArray = $this$forEach$iv;
        int n = fieldInfoArray.length;
        for (int i = 0; i < n; ++i) {
            FieldInfo element$iv;
            FieldInfo it = element$iv = fieldInfoArray[i];
            boolean bl = false;
            it.write(out);
        }
    }

    private final void readMethods(DataInput input) {
        MethodInfo[] methodInfoArray;
        int methodsCount = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read methods count " + methodsCount, input);
        }
        ClassFile classFile = this;
        MethodInfo[] methodInfoArray2 = new MethodInfo[methodsCount];
        int n = 0;
        while (n < methodsCount) {
            MethodInfo methodInfo;
            int n2 = n;
            int n3 = n++;
            methodInfoArray = methodInfoArray2;
            boolean bl = false;
            MethodInfo methodInfo2 = new MethodInfo(this);
            boolean bl2 = false;
            boolean bl3 = false;
            MethodInfo $this$apply = methodInfo2;
            boolean bl4 = false;
            $this$apply.read(input);
            methodInfoArray[n3] = methodInfo = methodInfo2;
        }
        methodInfoArray = methodInfoArray2;
        classFile.methods = methodInfoArray;
    }

    private final void writeMethods(DataOutput out) {
        int methodsCount = this.methods.length;
        out.writeShort(methodsCount);
        if (Package.isDebug()) {
            Package.debug("wrote methods count " + methodsCount, out);
        }
        MethodInfo[] $this$forEach$iv = this.methods;
        boolean $i$f$forEach = false;
        MethodInfo[] methodInfoArray = $this$forEach$iv;
        int n = methodInfoArray.length;
        for (int i = 0; i < n; ++i) {
            MethodInfo element$iv;
            MethodInfo it = element$iv = methodInfoArray[i];
            boolean bl = false;
            it.write(out);
        }
    }

    private final void checkMajorVersion(int majorVersion) {
        if (majorVersion < 45 || majorVersion > 61) {
            Package.warning("major version should be between 45 and 59 for JDK <= 17, was " + majorVersion);
        }
    }

    public ClassFile() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Structure[] answer$iv$iv;
        Map $this$getOrPut$iv$iv;
        boolean $i$f$emptyArraySingleton = false;
        Map map = Package.access$getArraySingletons$p();
        KClass key$iv$iv = Reflection.getOrCreateKotlinClass(Constant.class);
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            answer$iv$iv = new Constant[]{};
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object4 = answer$iv$iv;
        } else {
            object4 = value$iv$iv;
        }
        this.constantPool = (Constant[])((Object[])object4);
        this.constantPoolEntryToIndex = new HashMap();
        this.interfaces = new int[0];
        $i$f$emptyArraySingleton = false;
        $this$getOrPut$iv$iv = Package.access$getArraySingletons$p();
        key$iv$iv = Reflection.getOrCreateKotlinClass(FieldInfo.class);
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            answer$iv$iv = new FieldInfo[]{};
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object3 = answer$iv$iv;
        } else {
            object3 = value$iv$iv;
        }
        this.fields = (FieldInfo[])((Object[])object3);
        $i$f$emptyArraySingleton = false;
        $this$getOrPut$iv$iv = Package.access$getArraySingletons$p();
        key$iv$iv = Reflection.getOrCreateKotlinClass(MethodInfo.class);
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            answer$iv$iv = new MethodInfo[]{};
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object2 = answer$iv$iv;
        } else {
            object2 = value$iv$iv;
        }
        this.methods = (MethodInfo[])((Object[])object2);
        $i$f$emptyArraySingleton = false;
        $this$getOrPut$iv$iv = Package.access$getArraySingletons$p();
        key$iv$iv = Reflection.getOrCreateKotlinClass(AttributeInfo.class);
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            AttributeInfo[] answer$iv$iv2 = new AttributeInfo[]{};
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv2);
            object = answer$iv$iv2;
        } else {
            object = value$iv$iv;
        }
        this.attributes = (AttributeInfo[])((Object[])object);
    }

    @Override
    @Nullable
    public <T extends AttributeInfo> T findAttribute(@NotNull Class<T> attributeClass) {
        Intrinsics.checkNotNullParameter(attributeClass, (String)"attributeClass");
        return AttributeContainer.DefaultImpls.findAttribute(this, attributeClass);
    }

    @Override
    public int getTotalAttributesLength() {
        return AttributeContainer.DefaultImpls.getTotalAttributesLength(this);
    }

    @Override
    public void readAttributes(@NotNull AttributeContainer $this$readAttributes, @NotNull DataInput input, @NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)$this$readAttributes, (String)"$this$readAttributes");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        AttributeContainer.DefaultImpls.readAttributes(this, $this$readAttributes, input, classFile);
    }

    @Override
    public void writeAttributes(@NotNull AttributeContainer $this$writeAttributes, @NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAttributes, (String)"$this$writeAttributes");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        AttributeContainer.DefaultImpls.writeAttributes(this, $this$writeAttributes, output);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/gjt/jclasslib/structures/ClassFile$Companion;", "", "()V", "MAGIC_NUMBER", "", "data"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

