/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.attributes.SubStructure;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/gjt/jclasslib/structures/attributes/BootstrapMethodsEntry;", "Lorg/gjt/jclasslib/structures/attributes/SubStructure;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "argumentIndices", "", "getArgumentIndices", "()[I", "setArgumentIndices", "([I)V", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "length", "", "getLength", "()I", "methodRefIndex", "getMethodRefIndex", "setMethodRefIndex", "(I)V", "verbose", "getVerbose", "getVerboseIndex", "index", "readData", "", "input", "Ljava/io/DataInput;", "writeData", "output", "Ljava/io/DataOutput;", "data"})
public final class BootstrapMethodsEntry
extends SubStructure {
    private int methodRefIndex;
    @NotNull
    private int[] argumentIndices;
    private final ClassFile classFile;

    public final int getMethodRefIndex() {
        return this.methodRefIndex;
    }

    public final void setMethodRefIndex(int n) {
        this.methodRefIndex = n;
    }

    @NotNull
    public final int[] getArgumentIndices() {
        return this.argumentIndices;
    }

    public final void setArgumentIndices(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.argumentIndices = nArray;
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.methodRefIndex = input.readUnsignedShort();
        int argumentRefsCount = input.readUnsignedShort();
        BootstrapMethodsEntry bootstrapMethodsEntry = this;
        int[] nArray2 = new int[argumentRefsCount];
        int n = 0;
        while (n < argumentRefsCount) {
            int n2;
            int n3 = n;
            int n4 = n++;
            nArray = nArray2;
            boolean bl = false;
            nArray[n4] = n2 = input.readUnsignedShort();
        }
        nArray = nArray2;
        bootstrapMethodsEntry.argumentIndices = nArray;
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeShort(this.methodRefIndex);
        output.writeShort(this.argumentIndices.length);
        int[] $this$forEach$iv = this.argumentIndices;
        boolean $i$f$forEach = false;
        int[] nArray = $this$forEach$iv;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = nArray[i];
            boolean bl = false;
            output.writeShort(it);
        }
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with methodRefIndex " + this.methodRefIndex + ", arguments (" + this.getVerbose() + ')';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getVerbose() {
        StringBuilder buffer = new StringBuilder();
        int[] $this$forEachIndexed$iv = this.argumentIndices;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int item$iv : $this$forEachIndexed$iv) {
            void argumentIndex;
            int n = index$iv++;
            int n2 = item$iv;
            int i = n;
            boolean bl = false;
            if (i > 0) {
                buffer.append("\n");
            }
            buffer.append("<a href=\"").append((int)argumentIndex).append("\">cp_info #").append((int)argumentIndex).append("</a> &lt;").append(this.getVerboseIndex((int)argumentIndex)).append("&gt;");
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    private final String getVerboseIndex(int index) {
        return this.classFile.getConstantPoolEntryName(index);
    }

    @Override
    public int getLength() {
        return 4 + this.argumentIndices.length * 2;
    }

    public BootstrapMethodsEntry(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        this.classFile = classFile;
        this.argumentIndices = new int[0];
    }
}

