/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/gjt/jclasslib/structures/attributes/UnknownAttribute;", "Lorg/gjt/jclasslib/structures/AttributeInfo;", "byteArrayLength", "", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(ILorg/gjt/jclasslib/structures/ClassFile;)V", "getByteArrayLength", "()I", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "info", "", "getInfo", "()[B", "setInfo", "([B)V", "getAttributeLength", "getAttributeName", "readData", "", "input", "Ljava/io/DataInput;", "writeData", "output", "Ljava/io/DataOutput;", "data"})
public final class UnknownAttribute
extends AttributeInfo {
    @NotNull
    private byte[] info;
    private final int byteArrayLength;

    @NotNull
    public final byte[] getInfo() {
        return this.info;
    }

    public final void setInfo(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.info = byArray;
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        input.readFully(this.info);
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.write(this.info);
    }

    @Override
    public int getAttributeLength() {
        return this.info.length;
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "of reported type " + this.getAttributeName();
    }

    private final String getAttributeName() {
        String string;
        try {
            string = this.getClassFile().getConstantPoolUtf8Entry(this.getAttributeNameIndex()).getString();
        }
        catch (InvalidByteCodeException ex) {
            string = "(unknown)";
        }
        return string;
    }

    public final int getByteArrayLength() {
        return this.byteArrayLength;
    }

    public UnknownAttribute(int byteArrayLength, @NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
        this.byteArrayLength = byteArrayLength;
        this.info = new byte[this.byteArrayLength];
    }
}

