/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ConstantType;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantLargeNumeric;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantDoubleInfo;", "Lorg/gjt/jclasslib/structures/constants/ConstantLargeNumeric;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "constantType", "Lorg/gjt/jclasslib/structures/ConstantType;", "getConstantType", "()Lorg/gjt/jclasslib/structures/ConstantType;", "number", "", "double", "getDouble", "()D", "setDouble", "(D)V", "verbose", "", "getVerbose", "()Ljava/lang/String;", "writeData", "", "output", "Ljava/io/DataOutput;", "data"})
public final class ConstantDoubleInfo
extends ConstantLargeNumeric {
    @Override
    @NotNull
    public ConstantType getConstantType() {
        return ConstantType.DOUBLE;
    }

    @Override
    @NotNull
    public String getVerbose() throws InvalidByteCodeException {
        return String.valueOf(this.getDouble());
    }

    public final double getDouble() {
        long longBits = (long)this.getHighBytes() << 32 | (long)this.getLowBytes() & 0xFFFFFFFFL;
        return Double.longBitsToDouble(longBits);
    }

    public final void setDouble(double number) {
        long longBits = Double.doubleToLongBits(number);
        this.setHighBytes((int)(longBits >>> 32 & 0xFFFFFFFFL));
        this.setLowBytes((int)(longBits & 0xFFFFFFFFL));
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(ConstantType.DOUBLE.getTag());
        super.writeData(output);
    }

    public ConstantDoubleInfo(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }
}

