/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ConstantType;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantNumeric;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantFloatInfo;", "Lorg/gjt/jclasslib/structures/constants/ConstantNumeric;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "constantType", "Lorg/gjt/jclasslib/structures/ConstantType;", "getConstantType", "()Lorg/gjt/jclasslib/structures/ConstantType;", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "number", "", "float", "getFloat", "()F", "setFloat", "(F)V", "verbose", "getVerbose", "writeData", "", "output", "Ljava/io/DataOutput;", "data"})
public final class ConstantFloatInfo
extends ConstantNumeric {
    @Override
    @NotNull
    public ConstantType getConstantType() {
        return ConstantType.FLOAT;
    }

    @Override
    @NotNull
    public String getVerbose() throws InvalidByteCodeException {
        return String.valueOf(this.getFloat());
    }

    public final float getFloat() {
        return Float.intBitsToFloat(this.getBytes());
    }

    public final void setFloat(float number) {
        this.setBytes(Float.floatToIntBits(number));
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(ConstantType.FLOAT.getTag());
        super.writeData(output);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with bytes " + this.getBytes();
    }

    public ConstantFloatInfo(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }
}

