/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ConstantType;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.MethodHandleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020\u0016H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*H\u0014R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012\u00a8\u0006+"}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantMethodHandleInfo;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "type", "Lorg/gjt/jclasslib/structures/constants/MethodHandleType;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/constants/MethodHandleType;Lorg/gjt/jclasslib/structures/ClassFile;)V", "input", "Ljava/io/DataInput;", "(Lorg/gjt/jclasslib/structures/ClassFile;Ljava/io/DataInput;)V", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "constantType", "Lorg/gjt/jclasslib/structures/ConstantType;", "getConstantType", "()Lorg/gjt/jclasslib/structures/ConstantType;", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "name", "getName", "referenceIndex", "", "getReferenceIndex", "()I", "setReferenceIndex", "(I)V", "getType", "()Lorg/gjt/jclasslib/structures/constants/MethodHandleType;", "setType", "(Lorg/gjt/jclasslib/structures/constants/MethodHandleType;)V", "verbose", "getVerbose", "equals", "", "other", "", "hashCode", "readData", "", "writeData", "output", "Ljava/io/DataOutput;", "data"})
public final class ConstantMethodHandleInfo
extends AbstractConstant {
    private int referenceIndex;
    public MethodHandleType type;

    public final int getReferenceIndex() {
        return this.referenceIndex;
    }

    public final void setReferenceIndex(int n) {
        this.referenceIndex = n;
    }

    @NotNull
    public final MethodHandleType getType() {
        MethodHandleType methodHandleType = this.type;
        if (methodHandleType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
        }
        return methodHandleType;
    }

    public final void setType(@NotNull MethodHandleType methodHandleType) {
        Intrinsics.checkNotNullParameter((Object)methodHandleType, (String)"<set-?>");
        this.type = methodHandleType;
    }

    @Override
    @NotNull
    public ConstantType getConstantType() {
        return ConstantType.METHOD_HANDLE;
    }

    @Override
    @NotNull
    public String getVerbose() throws InvalidByteCodeException {
        return this.getName();
    }

    @NotNull
    public final String getName() throws InvalidByteCodeException {
        return this.getConstantType().getVerbose() + " " + this.getClassFile().getConstantPoolEntryName(this.referenceIndex);
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.type = (MethodHandleType)MethodHandleType.Companion.getFromTag(input.readByte());
        this.referenceIndex = input.readUnsignedShort();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(ConstantType.METHOD_HANDLE.getTag());
        MethodHandleType methodHandleType = this.type;
        if (methodHandleType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
        }
        output.write(methodHandleType.getTag());
        output.writeShort(this.referenceIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantMethodHandleInfo)) {
            return false;
        }
        if (!super.equals(other)) return false;
        if (((ConstantMethodHandleInfo)other).referenceIndex != this.referenceIndex) return false;
        MethodHandleType methodHandleType = ((ConstantMethodHandleInfo)other).type;
        if (methodHandleType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
        }
        MethodHandleType methodHandleType2 = this.type;
        if (methodHandleType2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
        }
        if (methodHandleType != methodHandleType2) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.referenceIndex;
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder().append("with referenceIndex ").append(this.referenceIndex).append(" and type ");
        MethodHandleType methodHandleType = this.type;
        if (methodHandleType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
        }
        return stringBuilder.append(methodHandleType).toString();
    }

    private ConstantMethodHandleInfo(ClassFile classFile) {
        super(classFile);
    }

    public ConstantMethodHandleInfo(@NotNull MethodHandleType type, @NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        this(classFile);
        this.type = type;
    }

    public ConstantMethodHandleInfo(@NotNull ClassFile classFile, @NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this(classFile);
        this.read(input);
    }
}

