/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ConstantType;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020\u0010H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u001a\u0010\u0017\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0014R\u0014\u0010\u001a\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\f\u00a8\u0006("}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantNameAndTypeInfo;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "constantType", "Lorg/gjt/jclasslib/structures/ConstantType;", "getConstantType", "()Lorg/gjt/jclasslib/structures/ConstantType;", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "descriptor", "getDescriptor", "descriptorIndex", "", "getDescriptorIndex", "()I", "setDescriptorIndex", "(I)V", "name", "getName", "nameIndex", "getNameIndex", "setNameIndex", "verbose", "getVerbose", "equals", "", "other", "", "hashCode", "readData", "", "input", "Ljava/io/DataInput;", "writeData", "output", "Ljava/io/DataOutput;", "data"})
public final class ConstantNameAndTypeInfo
extends AbstractConstant {
    private int nameIndex;
    private int descriptorIndex;

    public final int getNameIndex() {
        return this.nameIndex;
    }

    public final void setNameIndex(int n) {
        this.nameIndex = n;
    }

    public final int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public final void setDescriptorIndex(int n) {
        this.descriptorIndex = n;
    }

    @Override
    @NotNull
    public ConstantType getConstantType() {
        return ConstantType.NAME_AND_TYPE;
    }

    @Override
    @NotNull
    public String getVerbose() throws InvalidByteCodeException {
        return this.getName() + " : " + this.getDescriptor();
    }

    @NotNull
    public final String getName() throws InvalidByteCodeException {
        return this.getClassFile().getConstantPoolEntryName(this.nameIndex);
    }

    @NotNull
    public final String getDescriptor() throws InvalidByteCodeException {
        return this.getClassFile().getConstantPoolEntryName(this.descriptorIndex);
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.nameIndex = input.readUnsignedShort();
        this.descriptorIndex = input.readUnsignedShort();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(ConstantType.NAME_AND_TYPE.getTag());
        output.writeShort(this.nameIndex);
        output.writeShort(this.descriptorIndex);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with nameIndex " + this.nameIndex + " and descriptorIndex " + this.descriptorIndex;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantNameAndTypeInfo)) {
            return false;
        }
        return super.equals(other) && ((ConstantNameAndTypeInfo)other).nameIndex == this.nameIndex && ((ConstantNameAndTypeInfo)other).descriptorIndex == this.descriptorIndex;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.nameIndex ^ this.descriptorIndex;
    }

    public ConstantNameAndTypeInfo(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }
}

