/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0014R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantNameInfo;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "name", "getName", "nameIndex", "", "getNameIndex", "()I", "setNameIndex", "(I)V", "verbose", "getVerbose", "equals", "", "other", "", "hashCode", "readData", "", "input", "Ljava/io/DataInput;", "writeData", "output", "Ljava/io/DataOutput;", "data"})
public abstract class ConstantNameInfo
extends AbstractConstant {
    private int nameIndex;

    public final int getNameIndex() {
        return this.nameIndex;
    }

    public final void setNameIndex(int n) {
        this.nameIndex = n;
    }

    @Override
    @NotNull
    public String getVerbose() throws InvalidByteCodeException {
        return this.getName();
    }

    @NotNull
    public final String getName() throws InvalidByteCodeException {
        return this.getClassFile().getConstantPoolUtf8Entry(this.nameIndex).getString();
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.nameIndex = input.readUnsignedShort();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(this.getConstantType().getTag());
        output.writeShort(this.nameIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        Object object = other;
        if (Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass()) ^ true) {
            return false;
        }
        if (!super.equals(other)) return false;
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gjt.jclasslib.structures.constants.ConstantNameInfo");
        }
        if (((ConstantNameInfo)object2).nameIndex != this.nameIndex) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.nameIndex;
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with nameIndex " + this.nameIndex;
    }

    public ConstantNameInfo(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }
}

