/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.config;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.jclouds.aws.config.WithZonesFormSigningRestClientModule;
import org.jclouds.logging.Logger;
import org.jclouds.logging.jdk.JDKLogger;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(sequential=true, groups={"unit"})
public class AWSWithZonesFormSigningRestClientModuleTest {
    @Test
    public void testDefaultRegionWhenThereIsAMatch() {
        WithZonesFormSigningRestClientModule module = new WithZonesFormSigningRestClientModule(String.class, String.class);
        URI currentEndpoint = URI.create("http://region1");
        ImmutableMap map = ImmutableMap.of((Object)"region1", (Object)currentEndpoint, (Object)"region2", (Object)URI.create("http://region2"));
        Assert.assertEquals((String)"region1", (String)module.getDefaultRegion(currentEndpoint, (Map)map, (Logger.LoggerFactory)new JDKLogger.JDKLoggerFactory()));
    }

    @Test
    public void testDefaultRegionWhenThereIsNoMatch() {
        WithZonesFormSigningRestClientModule module = new WithZonesFormSigningRestClientModule(String.class, String.class);
        URI currentEndpoint = URI.create("http://region3");
        ImmutableMap map = ImmutableMap.of((Object)"region1", (Object)currentEndpoint, (Object)"region2", (Object)URI.create("http://region2"));
        Assert.assertEquals((String)"region1", (String)module.getDefaultRegion(currentEndpoint, (Map)map, (Logger.LoggerFactory)new JDKLogger.JDKLoggerFactory()));
    }
}

