/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.filters;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.jclouds.PropertiesBuilder;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.date.TimeStamp;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.rest.BaseRestClientTest;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.RestContextBuilder;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.rest.RestContextSpec;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="FormSignerTest")
public class FormSignerTest {
    public static final RestContextSpec<Map, List> DUMMY_SPEC = new RestContextSpec("provider", "endpoint", "apiVersion", "", "identity", "credential", Map.class, List.class, PropertiesBuilder.class, RestContextBuilder.class, (Iterable)ImmutableList.of((Object)new BaseRestClientTest.MockModule(), (Object)new NullLoggingModule(), (Object)new AbstractModule(){

        protected void configure() {
            this.bind(RequestSigner.class).to(FormSigner.class);
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"jclouds.aws.header.tag")).toInstance((Object)"amz");
            this.bind(String.class).annotatedWith(TimeStamp.class).toInstance((Object)"2009-11-08T15:54:08.897Z");
        }
    }));

    @Test
    void testBuildCanonicalizedString() {
        FormSigner filter = (FormSigner)RestContextFactory.createContextBuilder(DUMMY_SPEC).buildInjector().getInstance(FormSigner.class);
        Assert.assertEquals((String)filter.buildCanonicalizedString((Multimap)new ImmutableMultimap.Builder().put((Object)"AWSAccessKeyId", (Object)"foo").put((Object)"Action", (Object)"DescribeImages").put((Object)"Expires", (Object)"2008-02-10T12:00:00Z").put((Object)"ImageId.1", (Object)"ami-2bb65342").put((Object)"SignatureMethod", (Object)"HmacSHA256").put((Object)"SignatureVersion", (Object)"2").put((Object)"Version", (Object)"2010-06-15").build()), (String)"AWSAccessKeyId=foo&Action=DescribeImages&Expires=2008-02-10T12%3A00%3A00Z&ImageId.1=ami-2bb65342&SignatureMethod=HmacSHA256&SignatureVersion=2&Version=2010-06-15");
    }
}

