/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.handlers;

import org.easymock.classextension.EasyMock;
import org.jclouds.aws.handlers.AWSClientErrorRetryHandler;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class AWSClientErrorRetryHandlerTest {
    @Test
    public void test401DoesNotRetry() {
        AWSUtils utils = (AWSUtils)EasyMock.createMock(AWSUtils.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        org.easymock.EasyMock.expect((Object)command.getFailureCount()).andReturn((Object)0);
        org.easymock.EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)401).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{utils});
        EasyMock.replay((Object[])new Object[]{command});
        EasyMock.replay((Object[])new Object[]{response});
        AWSClientErrorRetryHandler retry = new AWSClientErrorRetryHandler(utils);
        assert (!retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{utils});
        EasyMock.verify((Object[])new Object[]{command});
        EasyMock.verify((Object[])new Object[]{response});
    }
}

