/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.util;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import org.easymock.classextension.EasyMock;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.filters.FormSignerTest;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.rest.RestContextFactory;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(sequential=true, groups={"unit"})
public class AWSUtilsTest {
    AWSUtils utils = null;
    private HttpCommand command;

    @BeforeTest
    protected void setUpInjector() throws IOException {
        Injector injector = RestContextFactory.createContextBuilder(FormSignerTest.DUMMY_SPEC).buildInjector();
        this.utils = (AWSUtils)injector.getInstance(AWSUtils.class);
        this.command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        org.easymock.EasyMock.expect((Object)this.command.getCurrentRequest()).andReturn(EasyMock.createMock(HttpRequest.class)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.command});
    }

    @AfterTest
    protected void tearDownInjector() {
        this.utils = null;
    }

    HttpResponse response(InputStream content) {
        HttpResponse response = new HttpResponse(400, "boa", (Payload)Payloads.newInputStreamPayload((InputStream)content), (Multimap)ImmutableMultimap.of((Object)"x-amz-request-id", (Object)"requestid", (Object)"x-amz-id-2", (Object)"requesttoken"));
        response.getPayload().getContentMetadata().setContentType("text/xml");
        return response;
    }

    @Test
    public void testParseAWSErrorFromContentHttpCommandHttpResponseInputStream() {
        AWSError error = this.utils.parseAWSErrorFromContent(this.command.getCurrentRequest(), this.response(this.getClass().getResourceAsStream("/error.xml")));
        Assert.assertEquals((String)error.getCode(), (String)"NoSuchKey");
        Assert.assertEquals((String)error.getMessage(), (String)"The resource you requested does not exist");
        Assert.assertEquals((String)error.getRequestToken(), (String)"requesttoken");
        Assert.assertEquals((String)error.getRequestId(), (String)"4442587FB7D0A2F9");
        Assert.assertEquals((String)((String)error.getDetails().get("Resource")), (String)"/mybucket/myfoto.jpg");
    }

    @Test
    public void testValidateBucketName() {
    }
}

