/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.assistedinject.Assisted;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.callables.ScriptStillRunningException;
import org.jclouds.compute.callables.SudoAwareInitManager;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.predicates.ScriptStatusReturnsZero;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.ssh.SshClient;

public class BlockUntilInitScriptStatusIsZeroThenReturnOutput
extends AbstractFuture<ExecResponse> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final ExecutorService userThreads;
    private final SudoAwareInitManager commandRunner;
    private final RetryablePredicate<String> notRunningAnymore;
    private boolean shouldCancel;

    @Inject
    public BlockUntilInitScriptStatusIsZeroThenReturnOutput(@Named(value="jclouds.user-threads") ExecutorService userThreads, ScriptStatusReturnsZero stateRunning, final @Assisted SudoAwareInitManager commandRunner) {
        this.commandRunner = (SudoAwareInitManager)Preconditions.checkNotNull((Object)commandRunner, (Object)"commandRunner");
        this.userThreads = (ExecutorService)Preconditions.checkNotNull((Object)userThreads, (Object)"userThreads");
        this.notRunningAnymore = new RetryablePredicate<String>((Predicate)new Predicate<String>(){

            public boolean apply(String arg0) {
                return commandRunner.runAction(arg0).getOutput().trim().equals("");
            }
        }, TimeUnit.DAYS.toMillis(365L)){

            protected boolean atOrAfter(Date end) {
                if (BlockUntilInitScriptStatusIsZeroThenReturnOutput.this.shouldCancel) {
                    Throwables.propagate((Throwable)new TimeoutException("cancelled"));
                }
                return super.atOrAfter(end);
            }
        };
    }

    public void setSshClient(SshClient client) {
    }

    @PostConstruct
    BlockUntilInitScriptStatusIsZeroThenReturnOutput init() {
        this.userThreads.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean complete = BlockUntilInitScriptStatusIsZeroThenReturnOutput.this.notRunningAnymore.apply((Object)"status");
                    String stdout = BlockUntilInitScriptStatusIsZeroThenReturnOutput.this.commandRunner.runAction("tail").getOutput();
                    String stderr = BlockUntilInitScriptStatusIsZeroThenReturnOutput.this.commandRunner.runAction("tailerr").getOutput();
                    BlockUntilInitScriptStatusIsZeroThenReturnOutput.this.logger.debug("<< complete(%s) status(%s)", new Object[]{BlockUntilInitScriptStatusIsZeroThenReturnOutput.this.commandRunner.getStatement().getInstanceName(), complete});
                    BlockUntilInitScriptStatusIsZeroThenReturnOutput.this.set(new ExecResponse(stdout, stderr, complete && !BlockUntilInitScriptStatusIsZeroThenReturnOutput.this.shouldCancel ? 0 : -1));
                }
                catch (Exception e) {
                    BlockUntilInitScriptStatusIsZeroThenReturnOutput.this.setException(e);
                }
            }
        });
        return this;
    }

    protected void interruptTask() {
        this.logger.debug("<< cancelled(%s)", new Object[]{this.commandRunner.getStatement().getInstanceName()});
        this.commandRunner.refreshAndRunAction("stop");
        this.shouldCancel = true;
        super.interruptTask();
    }

    public String toString() {
        return String.format("running task[%s]", this.commandRunner);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.commandRunner == null ? 0 : this.commandRunner.hashCode());
        result = 31 * result + (this.logger == null ? 0 : this.logger.hashCode());
        result = 31 * result + (this.notRunningAnymore == null ? 0 : this.notRunningAnymore.hashCode());
        result = 31 * result + (this.shouldCancel ? 1231 : 1237);
        result = 31 * result + (this.userThreads == null ? 0 : this.userThreads.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BlockUntilInitScriptStatusIsZeroThenReturnOutput other = (BlockUntilInitScriptStatusIsZeroThenReturnOutput)((Object)obj);
        if (this.commandRunner == null ? other.commandRunner != null : !this.commandRunner.equals(other.commandRunner)) {
            return false;
        }
        if (this.logger == null ? other.logger != null : !this.logger.equals(other.logger)) {
            return false;
        }
        if (this.notRunningAnymore == null ? other.notRunningAnymore != null : !this.notRunningAnymore.equals(other.notRunningAnymore)) {
            return false;
        }
        if (this.shouldCancel != other.shouldCancel) {
            return false;
        }
        return !(this.userThreads == null ? other.userThreads != null : !this.userThreads.equals(other.userThreads));
    }

    public ExecResponse get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        try {
            return (ExecResponse)super.get(timeout, unit);
        }
        catch (TimeoutException e) {
            throw new ScriptStillRunningException(timeout, unit, (ListenableFuture<ExecResponse>)this);
        }
    }

    public static interface Factory {
        public BlockUntilInitScriptStatusIsZeroThenReturnOutput create(SudoAwareInitManager var1);
    }
}

