/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.collect.TransformingSetSupplier;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.compute.strategy.impl.AdaptingComputeServiceStrategies;
import org.jclouds.domain.Location;

public class ComputeServiceAdapterContextModule<S, A, N, H, I, L>
extends BaseComputeServiceContextModule {
    private Class<A> asyncClientType;
    private Class<S> syncClientType;

    public ComputeServiceAdapterContextModule(Class<S> syncClientType, Class<A> asyncClientType) {
        this.syncClientType = syncClientType;
        this.asyncClientType = asyncClientType;
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceContext>(){}).to(TypeLiteral.get((Type)Types.newParameterizedType(ComputeServiceContextImpl.class, (Type[])new Type[]{this.syncClientType, this.asyncClientType}))).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    protected Supplier<Set<? extends Location>> provideLocations(final ComputeServiceAdapter<N, H, I, L> adapter, Function<L, Location> transformer) {
        return new TransformingSetSupplier(new Supplier<Iterable<L>>(){

            public Iterable<L> get() {
                return adapter.listLocations();
            }
        }, transformer);
    }

    @Provides
    @Singleton
    protected Supplier<Set<? extends Hardware>> provideHardware(final ComputeServiceAdapter<N, H, I, L> adapter, Function<H, Hardware> transformer) {
        return new TransformingSetSupplier(new Supplier<Iterable<H>>(){

            public Iterable<H> get() {
                return adapter.listHardwareProfiles();
            }
        }, transformer);
    }

    @Provides
    @Singleton
    protected Supplier<Set<? extends Image>> provideImages(final ComputeServiceAdapter<N, H, I, L> adapter, Function<I, Image> transformer) {
        return new TransformingSetSupplier(new Supplier<Iterable<I>>(){

            public Iterable<I> get() {
                return adapter.listImages();
            }
        }, transformer);
    }

    @Provides
    @Singleton
    protected CreateNodeWithGroupEncodedIntoName defineAddNodeWithTagStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected DestroyNodeStrategy defineDestroyNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected GetNodeMetadataStrategy defineGetNodeMetadataStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected ListNodesStrategy defineListNodesStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected RebootNodeStrategy defineRebootNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected ResumeNodeStrategy defineStartNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected SuspendNodeStrategy defineStopNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }
}

