/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodeRunning;
import org.jclouds.compute.predicates.NodeSuspended;
import org.jclouds.compute.predicates.NodeTerminated;
import org.jclouds.compute.predicates.ScriptStatusReturnsZero;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.predicates.RetryablePredicate;

public class ComputeServiceTimeoutsModule
extends AbstractModule {
    @Provides
    @Singleton
    @Named(value="NODE_RUNNING")
    protected Predicate<NodeMetadata> nodeRunning(NodeRunning stateRunning, ComputeServiceConstants.Timeouts timeouts) {
        return timeouts.nodeRunning == 0L ? stateRunning : new RetryablePredicate((Predicate)stateRunning, timeouts.nodeRunning);
    }

    @Provides
    @Singleton
    @Named(value="NODE_TERMINATED")
    protected Predicate<NodeMetadata> serverTerminated(NodeTerminated stateTerminated, ComputeServiceConstants.Timeouts timeouts) {
        return timeouts.nodeTerminated == 0L ? stateTerminated : new RetryablePredicate((Predicate)stateTerminated, timeouts.nodeTerminated);
    }

    @Provides
    @Singleton
    @Named(value="NODE_SUSPENDED")
    protected Predicate<NodeMetadata> serverSuspended(NodeSuspended stateSuspended, ComputeServiceConstants.Timeouts timeouts) {
        return timeouts.nodeSuspended == 0L ? stateSuspended : new RetryablePredicate((Predicate)stateSuspended, timeouts.nodeSuspended);
    }

    @Provides
    @Singleton
    @Named(value="SCRIPT_COMPLETE")
    protected Predicate<ScriptStatusReturnsZero.CommandUsingClient> runScriptRunning(ScriptStatusReturnsZero stateRunning, ComputeServiceConstants.Timeouts timeouts) {
        return timeouts.scriptComplete == 0L ? Predicates.not((Predicate)stateRunning) : new RetryablePredicate(Predicates.not((Predicate)stateRunning), timeouts.scriptComplete);
    }

    protected void configure() {
    }
}

