/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.domain.Location;
import org.jclouds.domain.internal.ResourceMetadataImpl;

public class ComputeMetadataImpl
extends ResourceMetadataImpl<ComputeType>
implements ComputeMetadata {
    private static final long serialVersionUID = 7374704415964898694L;
    private final String id;
    private final ComputeType type;
    protected final Set<String> tags;

    public ComputeMetadataImpl(ComputeType type, String providerId, String name, String id, Location location, URI uri, Map<String, String> userMetadata, Set<String> tags) {
        super(providerId, name, location, uri, userMetadata);
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.type = (ComputeType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
    }

    @Override
    public ComputeType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComputeMetadataImpl other = (ComputeMetadataImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.type == other.type;
    }
}

