/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.options;

import com.google.common.base.Preconditions;
import org.jclouds.domain.Credentials;

public class RunScriptOptions {
    public static final RunScriptOptions NONE = new ImmutableRunScriptOptions(new RunScriptOptions());
    protected int port = -1;
    protected int seconds = -1;
    protected String taskName;
    protected Credentials overridingCredentials;
    protected boolean runAsRoot = true;
    protected boolean blockOnComplete = true;
    protected boolean wrapInInitScript = true;

    public RunScriptOptions overrideCredentialsWith(Credentials overridingCredentials) {
        Preconditions.checkNotNull((Object)overridingCredentials, (Object)"overridingCredentials");
        this.overridingCredentials = overridingCredentials;
        return this;
    }

    public RunScriptOptions overrideLoginUserWith(String loginUser) {
        Preconditions.checkNotNull((Object)loginUser, (Object)"loginUser");
        Credentials.Builder builder = this.overridingCredentials != null ? this.overridingCredentials.toBuilder() : new Credentials.Builder();
        this.overridingCredentials = builder.identity(loginUser).build();
        return this;
    }

    public RunScriptOptions overrideLoginCredentialWith(String loginCredential) {
        Preconditions.checkNotNull((Object)loginCredential, (Object)"loginCredential");
        Credentials.Builder builder = this.overridingCredentials != null ? this.overridingCredentials.toBuilder() : new Credentials.Builder();
        this.overridingCredentials = builder.credential(loginCredential).build();
        return this;
    }

    public RunScriptOptions nameTask(String name) {
        this.taskName = name;
        return this;
    }

    public RunScriptOptions runAsRoot(boolean runAsRoot) {
        this.runAsRoot = runAsRoot;
        return this;
    }

    public RunScriptOptions wrapInInitScript(boolean wrapInInitScript) {
        this.wrapInInitScript = wrapInInitScript;
        return this;
    }

    public RunScriptOptions blockOnComplete(boolean blockOnComplete) {
        this.blockOnComplete = blockOnComplete;
        return this;
    }

    public RunScriptOptions blockOnPort(int port, int seconds) {
        Preconditions.checkArgument((port > 0 && port < 65536 ? 1 : 0) != 0, (Object)"port must be a positive integer < 65535");
        Preconditions.checkArgument((seconds > 0 ? 1 : 0) != 0, (Object)"seconds must be a positive integer");
        this.port = port;
        this.seconds = seconds;
        return this;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getPort() {
        return this.port;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public Credentials getOverridingCredentials() {
        return this.overridingCredentials;
    }

    public boolean shouldRunAsRoot() {
        return this.runAsRoot;
    }

    public boolean shouldBlockOnComplete() {
        return this.blockOnComplete;
    }

    public boolean shouldWrapInInitScript() {
        return this.wrapInInitScript;
    }

    public String toString() {
        return "[overridingCredentials=" + (this.overridingCredentials != null) + ", port:seconds=" + this.port + ":" + this.seconds + ", runAsRoot=" + this.runAsRoot + ", blockOnComplete=" + this.blockOnComplete + ", wrapInInitScript=" + this.wrapInInitScript + "]";
    }

    public static class Builder {
        public static RunScriptOptions nameTask(String name) {
            RunScriptOptions options = new RunScriptOptions();
            return options.nameTask(name);
        }

        public static RunScriptOptions overrideLoginUserWith(String user) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideLoginUserWith(user);
        }

        public static RunScriptOptions overrideLoginCredentialWith(String credential) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideLoginCredentialWith(credential);
        }

        public static RunScriptOptions overrideCredentialsWith(Credentials credentials) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideCredentialsWith(credentials);
        }

        public static RunScriptOptions runAsRoot(boolean value) {
            RunScriptOptions options = new RunScriptOptions();
            return options.runAsRoot(value);
        }

        public static RunScriptOptions blockOnComplete(boolean value) {
            RunScriptOptions options = new RunScriptOptions();
            return options.blockOnComplete(value);
        }

        public static RunScriptOptions wrapInInitScript(boolean value) {
            RunScriptOptions options = new RunScriptOptions();
            return options.wrapInInitScript(value);
        }

        public static RunScriptOptions blockOnPort(int port, int seconds) {
            RunScriptOptions options = new RunScriptOptions();
            return options.blockOnPort(port, seconds);
        }
    }

    public static class ImmutableRunScriptOptions
    extends RunScriptOptions {
        private final RunScriptOptions delegate;

        public ImmutableRunScriptOptions(RunScriptOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public Credentials getOverridingCredentials() {
            return this.delegate.getOverridingCredentials();
        }

        @Override
        public boolean shouldRunAsRoot() {
            return this.delegate.shouldRunAsRoot();
        }

        @Override
        public RunScriptOptions runAsRoot(boolean runAsRoot) {
            throw new IllegalArgumentException("runAsRoot is immutable");
        }

        @Override
        public boolean shouldBlockOnComplete() {
            return this.delegate.shouldBlockOnComplete();
        }

        @Override
        public RunScriptOptions blockOnComplete(boolean blockOnComplete) {
            throw new IllegalArgumentException("blockOnComplete is immutable");
        }

        @Override
        public RunScriptOptions overrideLoginUserWith(String loginUser) {
            throw new IllegalArgumentException("loginUser is immutable");
        }

        @Override
        public RunScriptOptions overrideLoginCredentialWith(String loginCredential) {
            throw new IllegalArgumentException("loginCredential is immutable");
        }

        @Override
        public RunScriptOptions wrapInInitScript(boolean wrapInInitScript) {
            throw new IllegalArgumentException("wrapInInitScript is immutable");
        }

        @Override
        public RunScriptOptions overrideCredentialsWith(Credentials overridingCredentials) {
            throw new IllegalArgumentException("overridingCredentials is immutable");
        }

        @Override
        public String getTaskName() {
            return this.delegate.getTaskName();
        }

        @Override
        public RunScriptOptions nameTask(String name) {
            throw new IllegalArgumentException("taskName is immutable");
        }

        @Override
        public RunScriptOptions blockOnPort(int port, int seconds) {
            throw new IllegalArgumentException("port, seconds are immutable");
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public int getSeconds() {
            return this.delegate.getSeconds();
        }
    }
}

