/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.options;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.io.Payload;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.util.Strings2;

public class TemplateOptions
extends RunScriptOptions
implements Cloneable {
    public static final TemplateOptions NONE = new ImmutableTemplateOptions(new TemplateOptions());
    protected int[] inboundPorts = new int[]{22};
    protected Statement script;
    protected Set<String> tags = ImmutableSet.of();
    protected String privateKey;
    protected String publicKey;
    protected boolean blockUntilRunning = true;
    protected Map<String, String> userMetadata = Maps.newLinkedHashMap();

    public TemplateOptions clone() {
        TemplateOptions options = new TemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        if (!Arrays.equals(to.getInboundPorts(), this.getInboundPorts())) {
            to.inboundPorts(this.getInboundPorts());
        }
        if (this.getRunScript() != null) {
            to.runScript(this.getRunScript());
        }
        if (this.getPrivateKey() != null) {
            to.installPrivateKey(this.getPrivateKey());
        }
        if (this.getPublicKey() != null) {
            to.authorizePublicKey(this.getPublicKey());
        }
        if (this.getPort() != -1) {
            to.blockOnPort(this.getPort(), this.getSeconds());
        }
        if (this.getUserMetadata().size() > 0) {
            to.userMetadata(this.getUserMetadata());
        }
        if (this.getTags().size() > 0) {
            to.tags(this.getTags());
        }
        if (!this.shouldBlockUntilRunning()) {
            to.blockUntilRunning(false);
        }
        if (!this.shouldBlockOnComplete()) {
            to.blockOnComplete(false);
        }
        if (this.getOverridingCredentials() != null) {
            to.overrideCredentialsWith(this.getOverridingCredentials());
        }
        if (this.getTaskName() != null) {
            to.nameTask(this.getTaskName());
        }
    }

    public int[] getInboundPorts() {
        return this.inboundPorts;
    }

    public Statement getRunScript() {
        return this.script;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public boolean shouldBlockUntilRunning() {
        return this.blockUntilRunning;
    }

    public <T extends TemplateOptions> T as(Class<T> clazz) {
        return (T)((TemplateOptions)clazz.cast(this));
    }

    @Deprecated
    public TemplateOptions runScript(byte[] script) {
        return this.runScript(Statements.exec((String)new String((byte[])Preconditions.checkNotNull((Object)script, (Object)"script"))));
    }

    public TemplateOptions runScript(Payload script) {
        try {
            return this.runScript(Statements.exec((String)Strings2.toStringAndClose((InputStream)((Payload)Preconditions.checkNotNull((Object)script, (Object)"script")).getInput())));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return this;
        }
    }

    public TemplateOptions runScript(Statement script) {
        this.script = (Statement)Preconditions.checkNotNull((Object)script, (Object)"script");
        return this;
    }

    public TemplateOptions installPrivateKey(String privateKey) {
        Preconditions.checkArgument((boolean)((String)Preconditions.checkNotNull((Object)privateKey, (Object)"privateKey")).startsWith("-----BEGIN RSA PRIVATE KEY-----"), (Object)"key should start with -----BEGIN RSA PRIVATE KEY-----");
        this.privateKey = privateKey;
        return this;
    }

    @Deprecated
    public TemplateOptions installPrivateKey(Payload privateKey) {
        try {
            return this.installPrivateKey(Strings2.toStringAndClose((InputStream)((Payload)Preconditions.checkNotNull((Object)privateKey, (Object)"privateKey")).getInput()));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return this;
        }
    }

    public TemplateOptions dontAuthorizePublicKey() {
        this.publicKey = null;
        return this;
    }

    public TemplateOptions authorizePublicKey(String publicKey) {
        Preconditions.checkArgument((boolean)((String)Preconditions.checkNotNull((Object)publicKey, (Object)"publicKey")).startsWith("ssh-rsa"), (Object)"key should start with ssh-rsa");
        this.publicKey = publicKey;
        return this;
    }

    @Deprecated
    public TemplateOptions authorizePublicKey(Payload publicKey) {
        try {
            return this.authorizePublicKey(Strings2.toStringAndClose((InputStream)((Payload)Preconditions.checkNotNull((Object)publicKey, (Object)"publicKey")).getInput()));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return this;
        }
    }

    public TemplateOptions tags(Iterable<String> tags) {
        this.tags = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(tags, (Object)"tags")));
        return this;
    }

    public TemplateOptions inboundPorts(int ... ports) {
        for (int port : ports) {
            Preconditions.checkArgument((port > 0 && port < 65536 ? 1 : 0) != 0, (Object)"port must be a positive integer < 65535");
        }
        this.inboundPorts = ports;
        return this;
    }

    @Override
    public String toString() {
        return "[inboundPorts=" + Arrays.toString(this.inboundPorts) + ", privateKey=" + (this.privateKey != null) + ", publicKey=" + (this.publicKey != null) + ", runScript=" + (this.script != null) + ", blockUntilRunning=" + this.blockUntilRunning + ", blockOnComplete=" + this.blockOnComplete + ", port:seconds=" + this.port + ":" + this.seconds + ", userMetadata: " + this.userMetadata + "]";
    }

    public TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        this.blockUntilRunning = blockUntilRunning;
        if (!blockUntilRunning) {
            this.seconds = -1;
            this.port = -1;
        }
        return this;
    }

    public TemplateOptions userMetadata(Map<String, String> userMetadata) {
        this.userMetadata.putAll((Map)Preconditions.checkNotNull(userMetadata, (Object)"userMetadata"));
        return this;
    }

    public TemplateOptions userMetadata(String key, String value) {
        this.userMetadata.put((String)Preconditions.checkNotNull((Object)key, (Object)"key"), (String)Preconditions.checkNotNull((Object)value, (Object)"value"));
        return this;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.blockUntilRunning ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.inboundPorts);
        result = 31 * result + this.port;
        result = 31 * result + (this.userMetadata == null ? 0 : ((Object)this.userMetadata).hashCode());
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        result = 31 * result + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
        result = 31 * result + this.seconds;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateOptions other = (TemplateOptions)obj;
        if (this.blockUntilRunning != other.blockUntilRunning) {
            return false;
        }
        if (!Arrays.equals(this.inboundPorts, other.inboundPorts)) {
            return false;
        }
        if (this.userMetadata == null ? other.userMetadata != null : !((Object)this.userMetadata).equals(other.userMetadata)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.privateKey == null ? other.privateKey != null : !this.privateKey.equals(other.privateKey)) {
            return false;
        }
        if (this.publicKey == null ? other.publicKey != null : !this.publicKey.equals(other.publicKey)) {
            return false;
        }
        if (this.script == null ? other.script != null : !this.script.equals(other.script)) {
            return false;
        }
        return this.seconds == other.seconds;
    }

    @Override
    public TemplateOptions blockOnPort(int port, int seconds) {
        return (TemplateOptions)TemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    @Override
    public TemplateOptions nameTask(String name) {
        return (TemplateOptions)TemplateOptions.class.cast(super.nameTask(name));
    }

    @Override
    public TemplateOptions runAsRoot(boolean runAsRoot) {
        return (TemplateOptions)TemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    @Override
    public TemplateOptions overrideCredentialsWith(Credentials overridingCredentials) {
        return (TemplateOptions)TemplateOptions.class.cast(super.overrideCredentialsWith(overridingCredentials));
    }

    @Override
    public TemplateOptions overrideLoginUserWith(String loginUser) {
        return (TemplateOptions)TemplateOptions.class.cast(super.overrideLoginUserWith(loginUser));
    }

    @Override
    public TemplateOptions overrideLoginCredentialWith(String loginCredential) {
        return (TemplateOptions)TemplateOptions.class.cast(super.overrideLoginCredentialWith(loginCredential));
    }

    @Override
    public TemplateOptions wrapInInitScript(boolean wrapInInitScript) {
        return (TemplateOptions)TemplateOptions.class.cast(super.wrapInInitScript(wrapInInitScript));
    }

    @Override
    public TemplateOptions blockOnComplete(boolean blockOnComplete) {
        return (TemplateOptions)TemplateOptions.class.cast(super.blockOnComplete(blockOnComplete));
    }

    public static class Builder
    extends RunScriptOptions.Builder {
        public static TemplateOptions nameTask(String name) {
            TemplateOptions options = new TemplateOptions();
            return options.nameTask(name);
        }

        public static TemplateOptions overrideLoginUserWith(String user) {
            TemplateOptions options = new TemplateOptions();
            return options.overrideLoginUserWith(user);
        }

        public static TemplateOptions overrideLoginCredentialWith(String credential) {
            TemplateOptions options = new TemplateOptions();
            return options.overrideLoginCredentialWith(credential);
        }

        public static TemplateOptions overrideCredentialsWith(Credentials credentials) {
            TemplateOptions options = new TemplateOptions();
            return options.overrideCredentialsWith(credentials);
        }

        public static TemplateOptions runAsRoot(boolean value) {
            TemplateOptions options = new TemplateOptions();
            return options.runAsRoot(value);
        }

        public static TemplateOptions blockOnPort(int port, int seconds) {
            TemplateOptions options = new TemplateOptions();
            return options.blockOnPort(port, seconds);
        }

        public static TemplateOptions inboundPorts(int ... ports) {
            TemplateOptions options = new TemplateOptions();
            return options.inboundPorts(ports);
        }

        public static TemplateOptions tags(Iterable<String> tags) {
            TemplateOptions options = new TemplateOptions();
            return options.tags(tags);
        }

        public static TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            TemplateOptions options = new TemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }

        @Deprecated
        public static TemplateOptions runScript(byte[] script) {
            TemplateOptions options = new TemplateOptions();
            return options.runScript(script);
        }

        public static TemplateOptions runScript(Payload script) {
            TemplateOptions options = new TemplateOptions();
            return options.runScript(script);
        }

        public static TemplateOptions runScript(Statement script) {
            TemplateOptions options = new TemplateOptions();
            return options.runScript(script);
        }

        @Deprecated
        public static TemplateOptions installPrivateKey(String rsaKey) {
            TemplateOptions options = new TemplateOptions();
            return options.installPrivateKey(rsaKey);
        }

        public static TemplateOptions installPrivateKey(Payload rsaKey) {
            TemplateOptions options = new TemplateOptions();
            return options.installPrivateKey(rsaKey);
        }

        @Deprecated
        public static TemplateOptions authorizePublicKey(String rsaKey) {
            TemplateOptions options = new TemplateOptions();
            return options.authorizePublicKey(rsaKey);
        }

        public static TemplateOptions authorizePublicKey(Payload rsaKey) {
            TemplateOptions options = new TemplateOptions();
            return options.authorizePublicKey(rsaKey);
        }

        public static TemplateOptions userMetadata(Map<String, String> userMetadata) {
            TemplateOptions options = new TemplateOptions();
            return options.userMetadata(userMetadata);
        }

        public static TemplateOptions userMetadata(String key, String value) {
            TemplateOptions options = new TemplateOptions();
            return options.userMetadata(key, value);
        }

        public static TemplateOptions blockOnComplete(boolean value) {
            TemplateOptions options = new TemplateOptions();
            return options.blockOnComplete(value);
        }
    }

    public static class ImmutableTemplateOptions
    extends TemplateOptions {
        private final TemplateOptions delegate;

        @Override
        public TemplateOptions clone() {
            return this.delegate.clone();
        }

        @Override
        public String getTaskName() {
            return this.delegate.getTaskName();
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public int getSeconds() {
            return this.delegate.getSeconds();
        }

        @Override
        public Credentials getOverridingCredentials() {
            return this.delegate.getOverridingCredentials();
        }

        @Override
        public boolean shouldRunAsRoot() {
            return this.delegate.shouldRunAsRoot();
        }

        @Override
        public boolean shouldBlockOnComplete() {
            return this.delegate.shouldBlockOnComplete();
        }

        @Override
        public boolean shouldWrapInInitScript() {
            return this.delegate.shouldWrapInInitScript();
        }

        @Override
        public void copyTo(TemplateOptions to) {
            this.delegate.copyTo(to);
        }

        public ImmutableTemplateOptions(TemplateOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public TemplateOptions runScript(Payload script) {
            throw new IllegalArgumentException("script is immutable");
        }

        @Override
        public TemplateOptions runScript(Statement script) {
            throw new IllegalArgumentException("script is immutable");
        }

        @Override
        public TemplateOptions installPrivateKey(Payload privateKey) {
            throw new IllegalArgumentException("privateKey is immutable");
        }

        @Override
        public TemplateOptions dontAuthorizePublicKey() {
            throw new IllegalArgumentException("public key is immutable");
        }

        @Override
        @Deprecated
        public TemplateOptions authorizePublicKey(Payload publicKey) {
            throw new IllegalArgumentException("public key is immutable");
        }

        @Override
        public TemplateOptions blockOnPort(int port, int seconds) {
            throw new IllegalArgumentException("ports are immutable");
        }

        @Override
        public TemplateOptions nameTask(String name) {
            throw new IllegalArgumentException("task name is immutable");
        }

        @Override
        public TemplateOptions runAsRoot(boolean runAsRoot) {
            throw new IllegalArgumentException("runAsRoot is immutable");
        }

        @Override
        public TemplateOptions overrideCredentialsWith(Credentials overridingCredentials) {
            throw new IllegalArgumentException("credentials are immutable");
        }

        @Override
        public TemplateOptions overrideLoginUserWith(String loginUser) {
            throw new IllegalArgumentException("credentials are immutable");
        }

        @Override
        public TemplateOptions overrideLoginCredentialWith(String loginCredential) {
            throw new IllegalArgumentException("credentials are immutable");
        }

        @Override
        public TemplateOptions wrapInInitScript(boolean wrapInInitScript) {
            throw new IllegalArgumentException("wrapInInitScript is immutable");
        }

        @Override
        public TemplateOptions blockOnComplete(boolean blockOnComplete) {
            throw new IllegalArgumentException("blockOnComplete is immutable");
        }

        @Override
        public <T extends TemplateOptions> T as(Class<T> clazz) {
            return this.delegate.as(clazz);
        }

        @Override
        public TemplateOptions authorizePublicKey(String publicKey) {
            throw new IllegalArgumentException("publicKey is immutable");
        }

        @Override
        public TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            throw new IllegalArgumentException("blockUntilRunning is immutable");
        }

        @Override
        public int[] getInboundPorts() {
            return this.delegate.getInboundPorts();
        }

        @Override
        public String getPrivateKey() {
            return this.delegate.getPrivateKey();
        }

        @Override
        public String getPublicKey() {
            return this.delegate.getPublicKey();
        }

        @Override
        public Statement getRunScript() {
            return this.delegate.getRunScript();
        }

        @Override
        public boolean shouldBlockUntilRunning() {
            return this.delegate.shouldBlockUntilRunning();
        }

        @Override
        public TemplateOptions inboundPorts(int ... ports) {
            throw new IllegalArgumentException("ports are immutable");
        }

        @Override
        public TemplateOptions installPrivateKey(String privateKey) {
            throw new IllegalArgumentException("privateKey is immutable");
        }

        @Override
        public TemplateOptions runScript(byte[] script) {
            throw new IllegalArgumentException("script is immutable");
        }

        @Override
        public Set<String> getTags() {
            return this.delegate.getTags();
        }

        @Override
        public TemplateOptions tags(Iterable<String> tags) {
            throw new IllegalArgumentException("tags are immutable");
        }

        @Override
        public TemplateOptions userMetadata(Map<String, String> userMetadata) {
            throw new IllegalArgumentException("userMetadata is immutable");
        }

        @Override
        public TemplateOptions userMetadata(String key, String value) {
            throw new IllegalArgumentException("userMetadata is immutable");
        }

        @Override
        public Map<String, String> getUserMetadata() {
            return this.delegate.getUserMetadata();
        }
    }
}

