/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Formatter;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.compute.ComputeServiceContextBuilder;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.predicates.RetryIfSocketNotYetOpen;
import org.jclouds.http.HttpRequest;
import org.jclouds.net.IPSocket;
import org.jclouds.rest.Providers;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class ComputeServiceUtils {
    public static final Pattern DELIMETED_BY_HYPHEN_ENDING_IN_HYPHEN_HEX = Pattern.compile("(.+)-[0-9a-f]+");

    public static Statement execHttpResponse(HttpRequest request) {
        return Statements.pipeHttpResponseToBash((String)request.getMethod(), (URI)request.getEndpoint(), (Multimap)request.getHeaders());
    }

    public static Statement execHttpResponse(URI location) {
        return ComputeServiceUtils.execHttpResponse(new HttpRequest("GET", location));
    }

    public static Statement extractTargzIntoDirectory(HttpRequest targz, String directory) {
        return Statements.extractTargzIntoDirectory((String)targz.getMethod(), (URI)targz.getEndpoint(), (Multimap)targz.getHeaders(), (String)directory);
    }

    public static Statement extractTargzIntoDirectory(URI targz, String directory) {
        return ComputeServiceUtils.extractTargzIntoDirectory(new HttpRequest("GET", targz), directory);
    }

    public static Statement extractZipIntoDirectory(HttpRequest zip, String directory) {
        return Statements.extractZipIntoDirectory((String)zip.getMethod(), (URI)zip.getEndpoint(), (Multimap)zip.getHeaders(), (String)directory);
    }

    public static Statement extractZipIntoDirectory(URI zip, String directory) {
        return ComputeServiceUtils.extractZipIntoDirectory(new HttpRequest("GET", zip), directory);
    }

    public static String parseGroupFromName(String from) {
        if (from == null) {
            return null;
        }
        Matcher matcher = DELIMETED_BY_HYPHEN_ENDING_IN_HYPHEN_HEX.matcher(from);
        return matcher.find() ? matcher.group(1) : null;
    }

    public static double getCores(Hardware input) {
        double cores = 0.0;
        for (Processor processor : input.getProcessors()) {
            cores += processor.getCores();
        }
        return cores;
    }

    public static double getCoresAndSpeed(Hardware input) {
        double total = 0.0;
        for (Processor processor : input.getProcessors()) {
            total += processor.getCores() * processor.getSpeed();
        }
        return total;
    }

    public static double getSpace(Hardware input) {
        double total = 0.0;
        for (Volume volume : input.getVolumes()) {
            total += volume.getSize() != null ? (double)volume.getSize().floatValue() : 0.0;
        }
        return total;
    }

    public static OsFamily parseOsFamilyOrUnrecognized(String in) {
        OsFamily myOs = null;
        for (OsFamily os : OsFamily.values()) {
            if (in.toLowerCase().replaceAll("\\s", "").indexOf(os.toString()) == -1) continue;
            myOs = os;
        }
        return myOs != null ? myOs : OsFamily.UNRECOGNIZED;
    }

    public static String createExecutionErrorMessage(Map<?, Exception> executionExceptions) {
        Formatter fmt = new Formatter().format("Execution failures:%n%n", new Object[0]);
        int index = 1;
        for (Map.Entry<?, Exception> errorMessage : executionExceptions.entrySet()) {
            fmt.format("%s) %s on %s:%n%s%n%n", index++, errorMessage.getValue().getClass().getSimpleName(), errorMessage.getKey(), Throwables.getStackTraceAsString((Throwable)errorMessage.getValue()));
        }
        return fmt.format("%s error[s]", executionExceptions.size()).toString();
    }

    public static String createNodeErrorMessage(Map<? extends NodeMetadata, ? extends Throwable> failedNodes) {
        Formatter fmt = new Formatter().format("Node failures:%n%n", new Object[0]);
        int index = 1;
        for (Map.Entry<? extends NodeMetadata, ? extends Throwable> errorMessage : failedNodes.entrySet()) {
            fmt.format("%s) %s on node %s:%n%s%n%n", index++, errorMessage.getValue().getClass().getSimpleName(), errorMessage.getKey().getId(), Throwables.getStackTraceAsString((Throwable)errorMessage.getValue()));
        }
        return fmt.format("%s error[s]", failedNodes.size()).toString();
    }

    public static Iterable<? extends ComputeMetadata> filterByName(Iterable<? extends ComputeMetadata> nodes, final String name) {
        return Iterables.filter(nodes, (Predicate)new Predicate<ComputeMetadata>(){

            public boolean apply(ComputeMetadata input) {
                return input.getName().equalsIgnoreCase(name);
            }
        });
    }

    public static Iterable<String> getSupportedProviders() {
        return Providers.getSupportedProvidersOfType(ComputeServiceContextBuilder.class);
    }

    public static IPSocket findReachableSocketOnNode(RetryIfSocketNotYetOpen socketTester, NodeMetadata node, final int port) {
        ComputeServiceUtils.checkNodeHasIps(node);
        IPSocket socket = null;
        try {
            socket = (IPSocket)Iterables.find((Iterable)Iterables.transform((Iterable)Iterables.concat(node.getPublicAddresses(), node.getPrivateAddresses()), (Function)new Function<String, IPSocket>(){

                public IPSocket apply(String from) {
                    return new IPSocket(from, port);
                }
            }), (Predicate)socketTester);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("could not connect to any ip address port %d on node %s", port, node));
        }
        return socket;
    }

    public static void checkNodeHasIps(NodeMetadata node) {
        Preconditions.checkState((Iterables.size((Iterable)Iterables.concat(node.getPublicAddresses(), node.getPrivateAddresses())) > 0 ? 1 : 0) != 0, (Object)("node does not have IP addresses configured: " + node));
    }

    public static String parseVersionOrReturnEmptyString(OsFamily family, String in, Map<OsFamily, Map<String, String>> osVersionMap) {
        if (osVersionMap.containsKey((Object)family)) {
            if (osVersionMap.get((Object)family).containsKey(in)) {
                return osVersionMap.get((Object)family).get(in);
            }
            if (osVersionMap.get((Object)family).containsValue(in)) {
                return in;
            }
            CONTAINS_SUBSTRING contains = new CONTAINS_SUBSTRING(in.replace('-', '.'));
            try {
                String key = (String)Iterables.find(osVersionMap.get((Object)family).keySet(), (Predicate)contains);
                return osVersionMap.get((Object)family).get(key);
            }
            catch (NoSuchElementException e) {
                try {
                    return (String)Iterables.find(osVersionMap.get((Object)family).values(), (Predicate)contains);
                }
                catch (NoSuchElementException e1) {
                    // empty catch block
                }
            }
        }
        return "";
    }

    static final class CONTAINS_SUBSTRING
    implements Predicate<String> {
        private final String in;

        CONTAINS_SUBSTRING(String in) {
            this.in = in;
        }

        public boolean apply(String input) {
            return this.in.indexOf(input) != -1;
        }
    }
}

