/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml.internal;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ovf.DiskSection;
import org.jclouds.ovf.NetworkSection;
import org.jclouds.ovf.Section;
import org.jclouds.ovf.internal.BaseEnvelope;
import org.jclouds.ovf.internal.BaseVirtualSystem;
import org.jclouds.ovf.xml.DiskSectionHandler;
import org.jclouds.ovf.xml.NetworkSectionHandler;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.ovf.xml.internal.BaseVirtualSystemHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BaseEnvelopeHandler<V extends BaseVirtualSystem<V>, B extends BaseVirtualSystem.Builder<V>, H extends BaseVirtualSystemHandler<V, B>, E extends BaseEnvelope<V, E>, T extends BaseEnvelope.Builder<V, E>>
extends ParseSax.HandlerWithResult<E> {
    protected final H virtualSystemHandler;
    protected final DiskSectionHandler diskHandler;
    protected final NetworkSectionHandler networkHandler;
    protected final Provider<T> envelopeBuilderProvider;
    protected T builder;
    protected SectionHandler defaultSectionHandler = SectionHandler.create();
    @Inject(optional=true)
    @Named(value="Envelope")
    Map<String, Provider<? extends SectionHandler>> extensionHandlers = ImmutableMap.of();
    protected SectionHandler extensionHandler;
    protected boolean inDisk;
    protected boolean inNetwork;
    protected boolean inVirtualSystem;
    protected boolean inSection;
    protected boolean inExtensionSection;
    protected int depth = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getResult() {
        try {
            Object e = ((BaseEnvelope.Builder)this.builder).build();
            return e;
        }
        finally {
            this.builder = (BaseEnvelope.Builder)this.envelopeBuilderProvider.get();
        }
    }

    @Inject
    public BaseEnvelopeHandler(DiskSectionHandler diskHandler, NetworkSectionHandler networkHandler, H virtualSystemHandler, Provider<T> envelopeBuilderProvider) {
        this.virtualSystemHandler = virtualSystemHandler;
        this.diskHandler = diskHandler;
        this.networkHandler = networkHandler;
        this.envelopeBuilderProvider = envelopeBuilderProvider;
        this.builder = (BaseEnvelope.Builder)envelopeBuilderProvider.get();
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        ++this.depth;
        if (this.depth == 2) {
            if (SaxUtils.equalsOrSuffix((String)qName, (String)"DiskSection")) {
                this.inDisk = true;
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"NetworkSection")) {
                this.inNetwork = true;
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"VirtualSystem")) {
                this.inVirtualSystem = true;
            } else if (this.extensionHandlers.containsKey(qName) || attributes.containsKey("type") && this.extensionHandlers.containsKey(attributes.get("type"))) {
                this.inExtensionSection = true;
                this.extensionHandler = (SectionHandler)((Object)this.extensionHandlers.get(qName).get());
            } else if (qName.endsWith("Section")) {
                this.inSection = true;
            }
        }
        if (this.inDisk) {
            this.diskHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inNetwork) {
            this.networkHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inVirtualSystem) {
            ((BaseVirtualSystemHandler)((Object)this.virtualSystemHandler)).startElement(uri, localName, qName, attrs);
        } else if (this.inExtensionSection) {
            this.extensionHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inSection) {
            this.defaultSectionHandler.startElement(uri, localName, qName, attrs);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        --this.depth;
        if (this.depth == 1) {
            if (SaxUtils.equalsOrSuffix((String)qName, (String)"DiskSection")) {
                this.inDisk = false;
                ((BaseEnvelope.Builder)this.builder).diskSection((DiskSection)this.diskHandler.getResult());
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"NetworkSection")) {
                this.inNetwork = false;
                ((BaseEnvelope.Builder)this.builder).networkSection((NetworkSection)this.networkHandler.getResult());
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"VirtualSystem")) {
                this.inVirtualSystem = false;
                ((BaseEnvelope.Builder)this.builder).virtualSystem((BaseVirtualSystem)((BaseVirtualSystem)((SectionHandler)((Object)this.virtualSystemHandler)).getResult()));
            } else if (this.extensionHandlers.containsKey(qName)) {
                ((BaseEnvelope.Builder)this.builder).additionalSection(qName, (Section)this.extensionHandler.getResult());
                this.inExtensionSection = false;
            } else if (qName.endsWith("Section")) {
                ((BaseEnvelope.Builder)this.builder).additionalSection(qName, (Section)this.defaultSectionHandler.getResult());
                this.inSection = false;
            }
        }
        if (this.inDisk) {
            this.diskHandler.endElement(uri, localName, qName);
        } else if (this.inNetwork) {
            this.networkHandler.endElement(uri, localName, qName);
        } else if (this.inVirtualSystem) {
            ((BaseVirtualSystemHandler)((Object)this.virtualSystemHandler)).endElement(uri, localName, qName);
        } else if (this.inExtensionSection) {
            this.extensionHandler.endElement(uri, localName, qName);
        } else if (this.inSection) {
            this.defaultSectionHandler.endElement(uri, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inDisk) {
            this.diskHandler.characters(ch, start, length);
        } else if (this.inNetwork) {
            this.networkHandler.characters(ch, start, length);
        } else if (this.inVirtualSystem) {
            ((BaseVirtualSystemHandler)((Object)this.virtualSystemHandler)).characters(ch, start, length);
        } else if (this.inExtensionSection) {
            this.extensionHandler.characters(ch, start, length);
        } else if (this.inSection) {
            this.defaultSectionHandler.characters(ch, start, length);
        }
    }
}

