/**
 *
 * Copyright (C) 2011 Cloud Conscious, LLC. <info@cloudconscious.com>
 *
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 */
package org.jclouds.scriptbuilder.functions;

import java.util.NoSuchElementException;

import javax.annotation.Nullable;

import org.jclouds.domain.Credentials;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;

/**
 * 
 * @author Adrian Cole
 */
public enum CredentialsFromAdminAccess implements Function<Statement, Credentials> {
   INSTANCE;
   @Override
   public Credentials apply(@Nullable Statement input) {
      if (input == null)
         return null;
      if (input instanceof StatementList) {
         try {
            return apply(Iterables.find(StatementList.class.cast(input).getStatements(),
                  Predicates.instanceOf(AdminAccess.class)));
         } catch (NoSuchElementException e) {
            return null;
         }
      } else if (input instanceof AdminAccess) {
         return AdminAccess.class.cast(input).getAdminCredentials();
      } else {
         return null;
      }
   }
}