/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.jclouds.scriptbuilder.ScriptBuilder;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.domain.SwitchArg;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScriptBuilderTest {
    ScriptBuilder testScriptBuilder = new ScriptBuilder().unsetEnvironmentVariable("runtime").addEnvironmentVariableScope("default", (Map)ImmutableMap.of((Object)"runtime", (Object)"Moo")).addStatement(Statements.switchArg((int)1, (Map)ImmutableMap.of((Object)"start", (Object)Statements.newStatementList((Statement[])new Statement[]{ScriptBuilder.call((String)"default", (String[])new String[0]), Statements.interpret((String[])new String[]{"echo start {varl}RUNTIME{varr}{lf}"})}), (Object)"stop", (Object)Statements.newStatementList((Statement[])new Statement[]{ScriptBuilder.call((String)"default", (String[])new String[0]), Statements.interpret((String[])new String[]{"echo stop {varl}RUNTIME{varr}{lf}"})}), (Object)"status", (Object)Statements.newStatementList((Statement[])new Statement[]{Statements.appendFile((String)"{tmp}{fs}{uid}{fs}scripttest{fs}temp.txt", (Iterable)ImmutableList.of((Object)"hello world")), Statements.interpret((String[])new String[]{"echo {vq}the following should be []: [{varl}RUNTIME{varr}]{vq}{lf}"})}))));
    ScriptBuilder findPidBuilder = new ScriptBuilder().addStatement(ScriptBuilder.findPid((String)"{args}")).addStatement(Statements.interpret((String[])new String[]{"echo {varl}FOUND_PID{varr}{lf}"}));
    ScriptBuilder seekAndDestroyBuilder = new ScriptBuilder().addStatement(ScriptBuilder.findPid((String)"{args}")).addStatement(Statements.kill());

    @Test
    public void testBuildSimpleWindows() throws MalformedURLException, IOException {
        Assert.assertEquals((String)this.testScriptBuilder.render(OsFamily.WINDOWS), (String)CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)Resources.getResource((String)("test_script." + ShellToken.SH.to(OsFamily.WINDOWS))), (Charset)Charsets.UTF_8)));
    }

    @Test
    public void testBuildSimpleUNIX() throws MalformedURLException, IOException {
        Assert.assertEquals((String)this.testScriptBuilder.render(OsFamily.UNIX), (String)CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)Resources.getResource((String)("test_script." + ShellToken.SH.to(OsFamily.UNIX))), (Charset)Charsets.UTF_8)));
    }

    @Test
    public void testFindPidWindows() throws MalformedURLException, IOException {
        Assert.assertEquals((String)this.findPidBuilder.render(OsFamily.WINDOWS), (String)CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)Resources.getResource((String)("test_find_pid." + ShellToken.SH.to(OsFamily.WINDOWS))), (Charset)Charsets.UTF_8)));
    }

    @Test
    public void testFindPidUNIX() throws MalformedURLException, IOException {
        Assert.assertEquals((String)this.findPidBuilder.render(OsFamily.UNIX), (String)CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)Resources.getResource((String)("test_find_pid." + ShellToken.SH.to(OsFamily.UNIX))), (Charset)Charsets.UTF_8)));
    }

    @Test
    public void testSeekAndDestroyWindows() throws MalformedURLException, IOException {
        Assert.assertEquals((String)this.seekAndDestroyBuilder.render(OsFamily.WINDOWS), (String)CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)Resources.getResource((String)("test_seek_and_destroy." + ShellToken.SH.to(OsFamily.WINDOWS))), (Charset)Charsets.UTF_8)));
    }

    @Test
    public void testSeekAndDestroyUNIX() throws MalformedURLException, IOException {
        Assert.assertEquals((String)this.seekAndDestroyBuilder.render(OsFamily.UNIX), (String)CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)Resources.getResource((String)("test_seek_and_destroy." + ShellToken.SH.to(OsFamily.UNIX))), (Charset)Charsets.UTF_8)));
    }

    @Test
    public void testSwitchOn() {
        ScriptBuilder builder = new ScriptBuilder();
        builder.addStatement(Statements.switchArg((int)1, (Map)ImmutableMap.of((Object)"start", (Object)Statements.interpret((String[])new String[]{"echo started{lf}"}), (Object)"stop", (Object)Statements.interpret((String[])new String[]{"echo stopped{lf}"}))));
        Assert.assertEquals((Collection)builder.statements, (Collection)ImmutableList.of((Object)new SwitchArg(1, (Map)ImmutableMap.of((Object)"start", (Object)Statements.interpret((String[])new String[]{"echo started{lf}"}), (Object)"stop", (Object)Statements.interpret((String[])new String[]{"echo stopped{lf}"})))));
    }

    @Test
    public void testNoSwitchOn() {
        ScriptBuilder builder = new ScriptBuilder();
        Assert.assertEquals((int)builder.statements.size(), (int)0);
    }

    @Test
    public void testExport() {
        ScriptBuilder builder = new ScriptBuilder();
        builder.addEnvironmentVariableScope("default", (Map)ImmutableMap.of((Object)"javaHome", (Object)"/apps/jdk1.6"));
        Assert.assertEquals((Map)builder.variableScopes, (Map)ImmutableMap.of((Object)"default", (Object)ImmutableMap.of((Object)"javaHome", (Object)"/apps/jdk1.6")));
    }

    @Test
    public void testNoExport() {
        ScriptBuilder builder = new ScriptBuilder();
        Assert.assertEquals((int)builder.variableScopes.size(), (int)0);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testExportNPE() {
        new ScriptBuilder().addEnvironmentVariableScope(null, null);
    }
}

