/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.util.Utils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class UtilsTest {
    public void testReplaceTokens() {
        Assert.assertEquals((String)Utils.replaceTokens((String)"hello {where}", (Map)ImmutableMap.of((Object)"where", (Object)"world")), (String)"hello world");
    }

    public void testWriteFunctionFromResourceAddsNewlineUNIX() {
        Assert.assertEquals((String)Utils.writeFunctionFromResource((String)"nonewline", (OsFamily)OsFamily.UNIX), (String)"foo\n");
    }

    public void testWriteFunctionFromResourceAddsNewlineWINDOWS() {
        Assert.assertEquals((String)Utils.writeFunctionFromResource((String)"nonewline", (OsFamily)OsFamily.WINDOWS), (String)"foo\r\n");
    }

    public void testWriteVariableExportersUNIX() {
        Assert.assertEquals((String)Utils.writeVariableExporters((Map)ImmutableMap.of((Object)"mavenOpts", (Object)"-Xms128m -Xmx256m -XX:+HeapDumpOnOutOfMemoryError"), (OsFamily)OsFamily.UNIX), (String)"export MAVEN_OPTS=\"-Xms128m -Xmx256m -XX:+HeapDumpOnOutOfMemoryError\"\n");
    }

    public void testWriteVariableExportersWindows() {
        Assert.assertEquals((String)Utils.writeVariableExporters((Map)ImmutableMap.of((Object)"mavenOpts", (Object)"-Xms128m -Xmx256m -XX:+HeapDumpOnOutOfMemoryError"), (OsFamily)OsFamily.WINDOWS), (String)"set MAVEN_OPTS=-Xms128m -Xmx256m -XX:+HeapDumpOnOutOfMemoryError\r\n");
    }

    public void testWritePositionalVarsUNIX() {
        Assert.assertEquals((String)Utils.writePositionalVars((List)ImmutableList.of((Object)"host", (Object)"port"), (OsFamily)OsFamily.UNIX), (String)"set HOST=$1\nshift\nset PORT=$1\nshift\n");
    }

    public void testWritePositionalVarsWindows() {
        Assert.assertEquals((String)Utils.writePositionalVars((List)ImmutableList.of((Object)"host", (Object)"port"), (OsFamily)OsFamily.WINDOWS), (String)"set HOST=%1\r\nshift\r\nset PORT=%1\r\nshift\r\n");
    }

    public void testWriteUnsetVariablesUNIX() {
        Assert.assertEquals((String)Utils.writeUnsetVariables((List)ImmutableList.of((Object)"host", (Object)"port"), (OsFamily)OsFamily.UNIX), (String)"unset HOST PORT\n");
    }

    public void testWriteUnsetVariablesWindows() {
        Assert.assertEquals((String)Utils.writeUnsetVariables((List)ImmutableList.of((Object)"host", (Object)"port"), (OsFamily)OsFamily.WINDOWS), (String)"set HOST=\r\nset PORT=\r\n");
    }

    public void testSingleCurlyBraceDoesntBreakLfTokenReplacement() {
        Assert.assertEquals((String)Utils.replaceTokens((String)"{{lf}", (Map)ShellToken.tokenValueMap((OsFamily)OsFamily.UNIX)), (String)"{\n");
    }
}

