/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.java;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

public class InstallJDK {
    public static Statement fromURL() {
        return new FromURL();
    }

    public static Statement fromURL(URI url) {
        return new FromURL(url);
    }

    public static class FromURL
    extends StatementList {
        public static final URI JDK7_URL = URI.create(System.getProperty("jdk7-url", "http://download.oracle.com/otn-pub/java/jdk/7/jdk-7-linux-x64.tar.gz"));
        public static final ImmutableSet<String> exportJavaHomeAndAddToPath = ImmutableSet.of((Object)"export JAVA_HOME=/usr/local/jdk", (Object)"export PATH=$JAVA_HOME/bin:$PATH");

        public FromURL() {
            this(JDK7_URL);
        }

        public FromURL(URI jdk7Url) {
            super(Statements.call("setupPublicCurl", new String[0]), Statements.extractTargzIntoDirectory(jdk7Url, "/usr/local"), Statements.exec("mv /usr/local/jdk* /usr/local/jdk/"), Statements.exec("test -n \"$SUDO_USER\" && "), Statements.appendFile("/home/$SUDO_USER/.bashrc", exportJavaHomeAndAddToPath), Statements.appendFile("/etc/bashrc", exportJavaHomeAndAddToPath), Statements.appendFile("$HOME/.bashrc", exportJavaHomeAndAddToPath), Statements.appendFile("/etc/skel/.bashrc", exportJavaHomeAndAddToPath), Statements.exec("ln -fs /usr/local/jdk/bin/java /usr/bin/java"));
        }
    }
}

