/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.statements.login.ReplaceShadowPasswordEntry;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ReplaceShadowPasswordEntryTest {
    public void testWithPasswordUNIX() {
        String userAdd = new ReplaceShadowPasswordEntry("foo", "bar").render(OsFamily.UNIX);
        assert (userAdd.startsWith("awk -v user=^foo: -v password='$6$")) : userAdd;
        assert (userAdd.endsWith("' 'BEGIN { FS=OFS=\":\" } $0 ~ user { $2 = password } 1' /etc/shadow >/etc/shadow.foo\ntest -f /etc/shadow.foo && mv /etc/shadow.foo /etc/shadow\n")) : userAdd;
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testAddUserWindowsNotSupported() {
        new ReplaceShadowPasswordEntry("user", "password").render(OsFamily.WINDOWS);
    }
}

