/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.util;

import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.util.ClassLoadingUtils;

public class Utils {
    public static final LowerCamelToUpperUnderscore FUNCTION_LOWER_CAMEL_TO_UPPER_UNDERSCORE = new LowerCamelToUpperUnderscore();
    public static final UpperUnderscoreToLowerCamel FUNCTION_UPPER_UNDERSCORE_TO_LOWER_CAMEL = new UpperUnderscoreToLowerCamel();
    private static final Pattern pattern = Pattern.compile("\\{([^\\{]+?)\\}");
    public static final Map<OsFamily, String> OS_TO_POSITIONAL_VAR_PATTERN = ImmutableMap.of((Object)((Object)OsFamily.UNIX), (Object)"set {key}=$1\nshift\n", (Object)((Object)OsFamily.WINDOWS), (Object)"set {key}=%1\r\nshift\r\n");
    public static final Map<OsFamily, String> OS_TO_LOCAL_VAR_PATTERN = ImmutableMap.of((Object)((Object)OsFamily.UNIX), (Object)"set {key}=\"{value}\"\n", (Object)((Object)OsFamily.WINDOWS), (Object)"set {key}={value}\r\n");
    public static final Map<OsFamily, String> OS_TO_ZERO_PATH = ImmutableMap.of((Object)((Object)OsFamily.WINDOWS), (Object)"set PATH=c:\\windows\\;C:\\windows\\system32;c:\\windows\\system32\\wbem\r\n", (Object)((Object)OsFamily.UNIX), (Object)"export PATH=/usr/ucb/bin:/bin:/sbin:/usr/bin:/usr/sbin\n");

    public static String replaceTokens(String input, Map<String, String> replacements) {
        Matcher matcher = pattern.matcher(input);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            builder.append(input.substring(i, matcher.start()));
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(input.substring(i, input.length()));
        return builder.toString();
    }

    public static String writeVariableExporters(Map<String, String> variablesInLowerCamelCase, OsFamily family) {
        return Utils.replaceTokens(Utils.writeVariableExporters(variablesInLowerCamelCase), ShellToken.tokenValueMap(family));
    }

    public static String writeVariableExporters(Map<String, String> variablesInLowerCamelCase) {
        StringBuilder initializers = new StringBuilder();
        for (Map.Entry<String, String> entry : variablesInLowerCamelCase.entrySet()) {
            String key = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, entry.getKey());
            initializers.append(String.format("{export} %s={vq}%s{vq}{lf}", key, entry.getValue()));
        }
        return initializers.toString();
    }

    public static String writeFunction(String function, String source, OsFamily family) {
        return Utils.replaceTokens(Utils.writeFunction(function, source), ShellToken.tokenValueMap(family));
    }

    public static String writeFunctionFromResource(String function, OsFamily family) {
        try {
            String toReturn = CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)ClassLoadingUtils.loadResource(Utils.class, (String)String.format("/functions/%s.%s", function, ShellToken.SH.to(family))), (Charset)Charsets.UTF_8));
            String lf = ShellToken.LF.to(family);
            return toReturn.endsWith(lf) ? toReturn : toReturn + lf;
        }
        catch (IOException e) {
            throw new FunctionNotFoundException(function, family, e);
        }
    }

    public static String writeFunction(String function, String source) {
        return String.format("{fncl}%s{fncr}%s{fnce}", function, source.replaceAll("^", "   "));
    }

    public static String writePositionalVars(List<String> positionalVariablesInLowerCamelCase, OsFamily family) {
        StringBuilder initializers = new StringBuilder();
        for (String variableInLowerCamelCase : positionalVariablesInLowerCamelCase) {
            String key = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, variableInLowerCamelCase);
            initializers.append(Utils.replaceTokens(OS_TO_POSITIONAL_VAR_PATTERN.get((Object)family), (Map<String, String>)ImmutableMap.of((Object)"key", (Object)key)));
        }
        return initializers.toString();
    }

    public static String writeUnsetVariables(List<String> variablesInLowerCamelCase, OsFamily family) {
        switch (family) {
            case UNIX: {
                return String.format("unset %s\n", Joiner.on((char)' ').join(Iterables.transform(variablesInLowerCamelCase, (Function)FUNCTION_LOWER_CAMEL_TO_UPPER_UNDERSCORE)));
            }
            case WINDOWS: {
                StringBuilder initializers = new StringBuilder();
                for (String variableInLowerCamelCase : variablesInLowerCamelCase) {
                    String key = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, variableInLowerCamelCase);
                    initializers.append(Utils.replaceTokens(OS_TO_LOCAL_VAR_PATTERN.get((Object)family), (Map<String, String>)ImmutableMap.of((Object)"key", (Object)key, (Object)"value", (Object)"")));
                }
                return initializers.toString();
            }
        }
        throw new UnsupportedOperationException("unsupported os: " + (Object)((Object)family));
    }

    public static String writeZeroPath(OsFamily family) {
        return OS_TO_ZERO_PATH.get((Object)family);
    }

    public static String writeComment(String comment, OsFamily family) {
        return String.format("%s%s%s", ShellToken.REM.to(family), comment, ShellToken.LF.to(family));
    }

    public static class FunctionNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public FunctionNotFoundException(String functionName, OsFamily family) {
            super("function: " + functionName + " not found for famiy: " + (Object)((Object)family));
        }

        public FunctionNotFoundException(String functionName, OsFamily family, Throwable cause) {
            super("function: " + functionName + " not found for famiy: " + (Object)((Object)family), cause);
        }
    }

    public static final class UpperUnderscoreToLowerCamel
    implements Function<String, String> {
        public String apply(String from) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, from);
        }
    }

    public static final class LowerCamelToUpperUnderscore
    implements Function<String, String> {
        public String apply(String from) {
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, from);
        }
    }
}

