/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.functionloader.osgi;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.functionloader.FunctionLoader;
import org.jclouds.scriptbuilder.functionloader.FunctionNotFoundException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class BundleFunctionLoader
implements FunctionLoader {
    private final BundleContext bundleContext;
    private ServiceRegistration registration;

    public BundleFunctionLoader(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void start() {
        Bundle bundle = this.bundleContext.getBundle();
        Enumeration entries = bundle.findEntries("/functions/", "*.*", false);
        StringBuilder sb = new StringBuilder();
        while (entries.hasMoreElements()) {
            URL url = (URL)entries.nextElement();
            String function = url.getFile();
            sb.append(function);
            if (!entries.hasMoreElements()) continue;
            sb.append(" ");
        }
        String functions = sb.toString();
        this.registerFunction(functions);
    }

    public void stop() {
        this.registration.unregister();
    }

    @Override
    public String loadFunction(String function, OsFamily family) throws FunctionNotFoundException {
        try {
            return CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)this.bundleContext.getBundle().getResource(String.format("/functions/%s.%s", function, ShellToken.SH.to(family))), (Charset)Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new FunctionNotFoundException(function, family, e);
        }
    }

    private void registerFunction(String functions) {
        Properties properties = new Properties();
        properties.put("function", functions);
        this.registration = this.bundleContext.registerService(FunctionLoader.class.getName(), (Object)this, (Dictionary)properties);
    }
}

