/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ShellTokenTest {
    public void testTokenValueMapUNIX() {
        ImmutableMap expected = new ImmutableMap.Builder().put((Object)"fs", (Object)"/").put((Object)"ps", (Object)":").put((Object)"lf", (Object)"\n").put((Object)"sh", (Object)"sh").put((Object)"source", (Object)".").put((Object)"rem", (Object)"#").put((Object)"args", (Object)"$@").put((Object)"varl", (Object)"$").put((Object)"return", (Object)"return").put((Object)"exit", (Object)"exit").put((Object)"varr", (Object)"").put((Object)"libraryPathVariable", (Object)"LD_LIBRARY_PATH").put((Object)"beginScript", (Object)"#!/bin/bash\nset +u\nshopt -s xpg_echo\nshopt -s expand_aliases\n").put((Object)"endScript", (Object)"exit $?\n").put((Object)"vq", (Object)"\"").put((Object)"beginFunctions", (Object)"").put((Object)"endFunctions", (Object)"").put((Object)"fncl", (Object)"function ").put((Object)"fncr", (Object)" {\n").put((Object)"fnce", (Object)"   return $?\n}\n").put((Object)"export", (Object)"export").put((Object)"rm", (Object)"rm").put((Object)"cd", (Object)"cd").put((Object)"tmp", (Object)"/tmp").put((Object)"uid", (Object)"$USER").put((Object)"root", (Object)"/").put((Object)"closeFd", (Object)">&-").put((Object)"md", (Object)"mkdir -p").put((Object)"escvar", (Object)"\\").build();
        Assert.assertEquals((Map)ShellToken.tokenValueMap((OsFamily)OsFamily.UNIX), (Map)expected);
    }

    public void testTokenValueMapWindows() {
        ImmutableMap expected = new ImmutableMap.Builder().put((Object)"fs", (Object)"\\").put((Object)"ps", (Object)";").put((Object)"lf", (Object)"\r\n").put((Object)"sh", (Object)"cmd").put((Object)"source", (Object)"@call").put((Object)"rem", (Object)"@rem").put((Object)"args", (Object)"%*").put((Object)"varl", (Object)"%").put((Object)"exit", (Object)"exit /b").put((Object)"varr", (Object)"%").put((Object)"libraryPathVariable", (Object)"PATH").put((Object)"return", (Object)"exit /b").put((Object)"vq", (Object)"").put((Object)"beginFunctions", (Object)"GOTO FUNCTION_END\r\n").put((Object)"endFunctions", (Object)":FUNCTION_END\r\n").put((Object)"beginScript", (Object)"@echo off\r\n").put((Object)"endScript", (Object)"exit /b 0\r\n").put((Object)"fncl", (Object)":").put((Object)"fncr", (Object)"\r\n").put((Object)"fnce", (Object)"   exit /b 0\r\n").put((Object)"export", (Object)"set").put((Object)"rm", (Object)"del").put((Object)"cd", (Object)"cd /d").put((Object)"tmp", (Object)"%TEMP%").put((Object)"uid", (Object)"%USERNAME%").put((Object)"root", (Object)"c:\\").put((Object)"closeFd", (Object)">NUL").put((Object)"md", (Object)"md").put((Object)"escvar", (Object)"%").build();
        Assert.assertEquals((Map)ShellToken.tokenValueMap((OsFamily)OsFamily.WINDOWS), (Map)expected);
    }
}

