/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.functions;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.domain.Credentials;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.functions.CredentialsFromAdminAccess;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CredentialsFromAdminAccessTest {
    public void testWhenNotAdminAccess() {
        Statement statement = Statements.exec((String)"echo hello");
        Assert.assertEquals((Object)CredentialsFromAdminAccess.INSTANCE.apply(statement), null);
        Statement statementList = Statements.newStatementList((Statement[])new Statement[]{statement});
        Assert.assertEquals((Object)CredentialsFromAdminAccess.INSTANCE.apply(statementList), null);
    }

    public void testWhenAdminAccess() {
        AdminAccess.Configuration configuration = (AdminAccess.Configuration)EasyMock.createMock(AdminAccess.Configuration.class);
        AdminAccess statement = (AdminAccess)EasyMock.createMock(AdminAccess.class);
        Credentials creds = (Credentials)EasyMock.createMock(Credentials.class);
        EasyMock.expect((Object)statement.getAdminCredentials()).andReturn((Object)creds);
        EasyMock.replay((Object[])new Object[]{configuration});
        EasyMock.replay((Object[])new Object[]{statement});
        EasyMock.replay((Object[])new Object[]{creds});
        Assert.assertEquals((Object)CredentialsFromAdminAccess.INSTANCE.apply((Statement)statement), (Object)creds);
        EasyMock.verify((Object[])new Object[]{configuration});
        EasyMock.verify((Object[])new Object[]{statement});
        EasyMock.verify((Object[])new Object[]{creds});
    }

    public void testWhenAdminAccessInsideList() {
        AdminAccess.Configuration configuration = (AdminAccess.Configuration)EasyMock.createMock(AdminAccess.Configuration.class);
        AdminAccess statement = (AdminAccess)EasyMock.createMock(AdminAccess.class);
        Credentials creds = (Credentials)EasyMock.createMock(Credentials.class);
        EasyMock.expect((Object)statement.getAdminCredentials()).andReturn((Object)creds);
        EasyMock.replay((Object[])new Object[]{configuration});
        EasyMock.replay((Object[])new Object[]{statement});
        EasyMock.replay((Object[])new Object[]{creds});
        Assert.assertEquals((Object)CredentialsFromAdminAccess.INSTANCE.apply(Statements.newStatementList((Statement[])new Statement[]{statement})), (Object)creds);
        EasyMock.verify((Object[])new Object[]{configuration});
        EasyMock.verify((Object[])new Object[]{statement});
        EasyMock.verify((Object[])new Object[]{creds});
    }

    public void testWhenAdminAccessInsideInitBuilder() {
        AdminAccess.Configuration configuration = (AdminAccess.Configuration)EasyMock.createMock(AdminAccess.Configuration.class);
        AdminAccess statement = (AdminAccess)EasyMock.createMock(AdminAccess.class);
        Credentials creds = (Credentials)EasyMock.createMock(Credentials.class);
        EasyMock.expect((Object)statement.getAdminCredentials()).andReturn((Object)creds);
        EasyMock.replay((Object[])new Object[]{configuration});
        EasyMock.replay((Object[])new Object[]{statement});
        EasyMock.replay((Object[])new Object[]{creds});
        InitScript testInitBuilder = InitScript.builder().name("mkebsboot").home("/mnt/tmp").exportVariables((Map)ImmutableMap.of((Object)"tmpDir", (Object)"/mnt/tmp")).run((Statement)statement).build();
        Assert.assertEquals((Object)CredentialsFromAdminAccess.INSTANCE.apply((Statement)testInitBuilder), (Object)creds);
        EasyMock.verify((Object[])new Object[]{configuration});
        EasyMock.verify((Object[])new Object[]{statement});
        EasyMock.verify((Object[])new Object[]{creds});
    }
}

