/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import com.google.common.collect.ImmutableList;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.statements.login.UserAdd;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class UserAddTest {
    public void testUNIX() {
        Assert.assertEquals((String)UserAdd.builder().login("me").build().render(OsFamily.UNIX), (String)"mkdir -p /home/users\nuseradd -s /bin/bash -m  -d /home/users/me me\nchown -R me /home/users/me\n");
    }

    public void testWithBaseUNIX() {
        Assert.assertEquals((String)UserAdd.builder().login("me").defaultHome("/export/home").build().render(OsFamily.UNIX), (String)"mkdir -p /export/home\nuseradd -s /bin/bash -m  -d /export/home/me me\nchown -R me /export/home/me\n");
    }

    public void testWithGroupUNIX() {
        Assert.assertEquals((String)UserAdd.builder().login("me").group("wheel").build().render(OsFamily.UNIX), (String)"mkdir -p /home/users\ngroupadd -f wheel\nuseradd -s /bin/bash -g wheel -m  -d /home/users/me me\nchown -R me /home/users/me\n");
    }

    public void testWithGroupsUNIX() {
        Assert.assertEquals((String)UserAdd.builder().login("me").groups((Iterable)ImmutableList.of((Object)"wheel", (Object)"candy")).build().render(OsFamily.UNIX), (String)"mkdir -p /home/users\ngroupadd -f wheel\ngroupadd -f candy\nuseradd -s /bin/bash -g wheel -G candy -m  -d /home/users/me me\nchown -R me /home/users/me\n");
    }

    public void testWithPasswordUNIX() {
        String userAdd = UserAdd.builder().login("me").password("foo").group("wheel").build().render(OsFamily.UNIX);
        assert (userAdd.startsWith("mkdir -p /home/users\ngroupadd -f wheel\nuseradd -s /bin/bash -g wheel -m  -d /home/users/me -p '$6$")) : userAdd;
        assert (userAdd.endsWith("' me\nchown -R me /home/users/me\n")) : userAdd;
    }

    public void testWithSshAuthorizedKeyUNIX() {
        Assert.assertEquals((String)UserAdd.builder().login("me").authorizeRSAPublicKey("rsapublickey").build().render(OsFamily.UNIX), (String)"mkdir -p /home/users\nuseradd -s /bin/bash -m  -d /home/users/me me\nmkdir -p /home/users/me/.ssh\ncat >> /home/users/me/.ssh/authorized_keys <<-'END_OF_JCLOUDS_FILE'\n\trsapublickey\nEND_OF_JCLOUDS_FILE\nchmod 600 /home/users/me/.ssh/authorized_keys\nchown -R me /home/users/me\n");
    }

    public void testWithSshInstalledKeyUNIX() {
        Assert.assertEquals((String)UserAdd.builder().login("me").installRSAPrivateKey("rsaprivate").build().render(OsFamily.UNIX), (String)"mkdir -p /home/users\nuseradd -s /bin/bash -m  -d /home/users/me me\nmkdir -p /home/users/me/.ssh\nrm /home/users/me/.ssh/id_rsa\ncat >> /home/users/me/.ssh/id_rsa <<-'END_OF_JCLOUDS_FILE'\n\trsaprivate\nEND_OF_JCLOUDS_FILE\nchmod 600 /home/users/me/.ssh/id_rsa\nchown -R me /home/users/me\n");
    }

    public void testWithHomeUNIX() {
        Assert.assertEquals((String)UserAdd.builder().login("me").home("/myhome/myme").build().render(OsFamily.UNIX), (String)"mkdir -p /myhome\nuseradd -s /bin/bash -m  -d /myhome/myme me\nchown -R me /myhome/myme\n");
        Assert.assertEquals((String)UserAdd.builder().login("me").home("/myhome/myme").defaultHome("/ignoreddefault").build().render(OsFamily.UNIX), (String)"mkdir -p /myhome\nuseradd -s /bin/bash -m  -d /myhome/myme me\nchown -R me /myhome/myme\n");
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testAddUserWindowsNotSupported() {
        UserAdd.builder().login("me").build().render(OsFamily.WINDOWS);
    }
}

