/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.git;

import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.statements.git.CloneGitRepo;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CloneGitRepoTest")
public class CloneGitRepoTest {
    public void testUNIX() {
        Assert.assertEquals((String)CloneGitRepo.builder().repository("https://github.com/joyent/node.git").build().render(OsFamily.UNIX), (String)"git clone https://github.com/joyent/node.git\ncd node\n");
    }

    public void testWithBranchUNIX() {
        Assert.assertEquals((String)CloneGitRepo.builder().repository("https://github.com/joyent/node.git").branch("v0.6").build().render(OsFamily.UNIX), (String)"git clone -b v0.6 https://github.com/joyent/node.git\ncd node\n");
    }

    public void testWithBranchAndTagUNIX() {
        Assert.assertEquals((String)CloneGitRepo.builder().repository("https://github.com/joyent/node.git").branch("v0.6").tag("v0.6.10").build().render(OsFamily.UNIX), (String)"git clone -b v0.6 https://github.com/joyent/node.git\ncd node\ngit checkout v0.6.10\n");
    }

    public void testWithDirectoryUNIX() {
        Assert.assertEquals((String)CloneGitRepo.builder().repository("https://github.com/joyent/node.git").directory("/tmp/node-local").build().render(OsFamily.UNIX), (String)"git clone https://github.com/joyent/node.git /tmp/node-local\ncd /tmp/node-local\n");
    }
}

