/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import com.google.gson.Gson;
import java.io.File;
import java.lang.reflect.Field;
import javax.inject.Provider;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.scriptbuilder.statements.login.AdminAccessBuilderSpec;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="AdminAccessBuilderSpecTest")
public class AdminAccessBuilderSpecTest {
    Provider<AdminAccess.Builder> adminAccessBuilders = new Provider<AdminAccess.Builder>(){

        public AdminAccess.Builder get() {
            return new AdminAccess.Builder();
        }
    };

    public void testParseEmpty() {
        AdminAccessBuilderSpec spec = AdminAccessBuilderSpec.parse((String)"");
        Assert.assertNull((Object)spec.adminHome);
        Assert.assertNull((Object)spec.adminPassword);
        Assert.assertNull((Object)spec.adminPrivateKeyFile);
        Assert.assertNull((Object)spec.adminPublicKeyFile);
        Assert.assertNull((Object)spec.adminUsername);
        Assert.assertNull((Object)spec.authorizeAdminPublicKey);
        Assert.assertNull((Object)spec.grantSudoToAdminUser);
        Assert.assertNull((Object)spec.installAdminPrivateKey);
        Assert.assertNull((Object)spec.lockSsh);
        Assert.assertNull((Object)spec.loginPassword);
        Assert.assertNull((Object)spec.resetLoginPassword);
        this.assertAdminAccessBuilderEquivalence((AdminAccess.Builder)this.adminAccessBuilders.get(), ((AdminAccess.Builder)this.adminAccessBuilders.get()).from(spec));
    }

    public void testParseAdminUsername() {
        AdminAccessBuilderSpec spec = AdminAccessBuilderSpec.parse((String)"adminUsername=superUser");
        Assert.assertEquals((String)spec.adminUsername, (String)"superUser");
        Assert.assertNull((Object)spec.adminHome);
        Assert.assertNull((Object)spec.adminPassword);
        Assert.assertNull((Object)spec.adminPrivateKeyFile);
        Assert.assertNull((Object)spec.adminPublicKeyFile);
        Assert.assertNull((Object)spec.authorizeAdminPublicKey);
        Assert.assertNull((Object)spec.grantSudoToAdminUser);
        Assert.assertNull((Object)spec.installAdminPrivateKey);
        Assert.assertNull((Object)spec.lockSsh);
        Assert.assertNull((Object)spec.loginPassword);
        Assert.assertNull((Object)spec.resetLoginPassword);
        this.assertAdminAccessBuilderEquivalence(((AdminAccess.Builder)this.adminAccessBuilders.get()).adminUsername("superUser"), ((AdminAccess.Builder)this.adminAccessBuilders.get()).from(spec));
    }

    public void testParseAdminHome() {
        AdminAccessBuilderSpec spec = AdminAccessBuilderSpec.parse((String)"adminHome=/home/superUser");
        Assert.assertEquals((String)spec.getAdminHome(), (String)"/home/superUser");
        Assert.assertNull((Object)spec.adminUsername);
        Assert.assertNull((Object)spec.adminPassword);
        Assert.assertNull((Object)spec.adminPrivateKeyFile);
        Assert.assertNull((Object)spec.adminPublicKeyFile);
        Assert.assertNull((Object)spec.authorizeAdminPublicKey);
        Assert.assertNull((Object)spec.grantSudoToAdminUser);
        Assert.assertNull((Object)spec.installAdminPrivateKey);
        Assert.assertNull((Object)spec.lockSsh);
        Assert.assertNull((Object)spec.loginPassword);
        Assert.assertNull((Object)spec.resetLoginPassword);
        this.assertAdminAccessBuilderEquivalence(((AdminAccess.Builder)this.adminAccessBuilders.get()).adminHome("/home/superUser"), ((AdminAccess.Builder)this.adminAccessBuilders.get()).from(spec));
    }

    public void testParsePrivateKeyFile() {
        AdminAccessBuilderSpec spec = AdminAccessBuilderSpec.parse((String)"adminPrivateKeyFile=target/test-classes/test");
        Assert.assertEquals((String)spec.getAdminPrivateKeyFile().getPath(), (String)String.format("target%stest-classes%stest", File.separator, File.separator));
        Assert.assertNull((Object)spec.adminHome);
        Assert.assertNull((Object)spec.adminPassword);
        Assert.assertNull((Object)spec.adminPublicKeyFile);
        Assert.assertNull((Object)spec.authorizeAdminPublicKey);
        Assert.assertNull((Object)spec.grantSudoToAdminUser);
        Assert.assertNull((Object)spec.installAdminPrivateKey);
        Assert.assertNull((Object)spec.lockSsh);
        Assert.assertNull((Object)spec.loginPassword);
        Assert.assertNull((Object)spec.resetLoginPassword);
        this.assertAdminAccessBuilderEquivalence(((AdminAccess.Builder)this.adminAccessBuilders.get()).adminHome("/home/superUser"), ((AdminAccess.Builder)this.adminAccessBuilders.get()).from(spec));
    }

    public void testParseLockSSh() {
        AdminAccessBuilderSpec spec = AdminAccessBuilderSpec.parse((String)"lockSsh=true");
        Assert.assertEquals((Object)spec.getLockSsh(), (Object)Boolean.TRUE);
        Assert.assertNull((Object)spec.adminUsername);
        Assert.assertNull((Object)spec.adminHome);
        Assert.assertNull((Object)spec.adminPassword);
        Assert.assertNull((Object)spec.adminPrivateKeyFile);
        Assert.assertNull((Object)spec.adminPublicKeyFile);
        Assert.assertNull((Object)spec.authorizeAdminPublicKey);
        Assert.assertNull((Object)spec.grantSudoToAdminUser);
        Assert.assertNull((Object)spec.installAdminPrivateKey);
        Assert.assertNull((Object)spec.loginPassword);
        Assert.assertNull((Object)spec.resetLoginPassword);
        this.assertAdminAccessBuilderEquivalence(((AdminAccess.Builder)this.adminAccessBuilders.get()).lockSsh(true), ((AdminAccess.Builder)this.adminAccessBuilders.get()).from(spec));
    }

    public void testParseAdminUsernameRepeated() {
        try {
            AdminAccessBuilderSpec.parse((String)"adminUsername=superUser, adminUsername=notSoSuperUser");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseNonExistingFiles() {
        try {
            AdminAccessBuilderSpec.parse((String)"adminPrivateKeyFile=nonExistingFile.txt");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            AdminAccessBuilderSpec.parse((String)"adminPublicKeyFile=nonExistingFile.txt");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNiceJson() {
        AdminAccessBuilderSpec spec = AdminAccessBuilderSpec.parse((String)"adminUsername=nimda,adminPassword=dictionaryword");
        Assert.assertEquals((String)new Gson().toJson((Object)spec), (String)"{\"adminUsername\":\"nimda\",\"adminPassword\":\"dictionaryword\"}");
        Assert.assertEquals((Object)new Gson().fromJson(new Gson().toJson((Object)spec), AdminAccessBuilderSpec.class), (Object)spec);
    }

    public void testParse_unknownKey() {
        try {
            AdminAccessBuilderSpec.parse((String)"foo=17");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAdminAccessBuilderFromString() {
        AdminAccess.Builder fromString = ((AdminAccess.Builder)this.adminAccessBuilders.get()).from("adminUsername=nimda,adminPassword=dictionaryword");
        AdminAccess.Builder expected = ((AdminAccess.Builder)this.adminAccessBuilders.get()).adminUsername("nimda").adminPassword("dictionaryword");
        this.assertAdminAccessBuilderEquivalence(expected, fromString);
    }

    private void assertAdminAccessBuilderEquivalence(AdminAccess.Builder a, AdminAccess.Builder b) {
        for (Field f : AdminAccess.Builder.class.getFields()) {
            f.setAccessible(true);
            try {
                Assert.assertEquals((Object)f.get(a), (Object)f.get(b), (String)("Field " + f.getName() + " not equal"));
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e.getMessage());
            }
        }
    }
}

