/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.scriptbuilder.statements.login.TestConfiguration;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="AdminAccessTest")
public class AdminAccessTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStandardUNIX() throws IOException {
        TestConfiguration.INSTANCE.reset();
        try {
            Assert.assertEquals((String)AdminAccess.standard().init((AdminAccess.Configuration)TestConfiguration.INSTANCE).render(OsFamily.UNIX), (String)CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)Resources.getResource((String)"test_adminaccess_standard.sh"), (Charset)Charsets.UTF_8)));
        }
        finally {
            TestConfiguration.INSTANCE.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithParamsUNIX() throws IOException {
        TestConfiguration.INSTANCE.reset();
        try {
            Assert.assertEquals((String)AdminAccess.builder().adminPassword("bar").adminPrivateKey("fooPrivateKey").adminPublicKey("fooPublicKey").adminUsername("foo").adminHome("/over/ridden/foo").build().init((AdminAccess.Configuration)TestConfiguration.INSTANCE).render(OsFamily.UNIX), (String)CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)Resources.getResource((String)"test_adminaccess_params.sh"), (Charset)Charsets.UTF_8)));
        }
        finally {
            TestConfiguration.INSTANCE.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithParamsAndFullNameUNIX() throws IOException {
        TestConfiguration.INSTANCE.reset();
        try {
            Assert.assertEquals((String)AdminAccess.builder().adminPassword("bar").adminPrivateKey("fooPrivateKey").adminPublicKey("fooPublicKey").adminUsername("foo").adminFullName("JClouds Foo").adminHome("/over/ridden/foo").build().init((AdminAccess.Configuration)TestConfiguration.INSTANCE).render(OsFamily.UNIX), (String)CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)Resources.getResource((String)"test_adminaccess_params_and_fullname.sh"), (Charset)Charsets.UTF_8)));
        }
        finally {
            TestConfiguration.INSTANCE.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOnlyInstallUserUNIX() throws IOException {
        TestConfiguration.INSTANCE.reset();
        try {
            Assert.assertEquals((String)AdminAccess.builder().grantSudoToAdminUser(false).authorizeAdminPublicKey(true).installAdminPrivateKey(true).lockSsh(false).resetLoginPassword(false).build().init((AdminAccess.Configuration)TestConfiguration.INSTANCE).render(OsFamily.UNIX), (String)CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)Resources.getResource((String)"test_adminaccess_plainuser.sh"), (Charset)Charsets.UTF_8)));
        }
        finally {
            TestConfiguration.INSTANCE.reset();
        }
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testCreateWheelWindowsNotSupported() {
        AdminAccess.standard().init((AdminAccess.Configuration)TestConfiguration.INSTANCE).render(OsFamily.WINDOWS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRootNotAllowed() throws IOException {
        TestConfiguration.INSTANCE.reset();
        try {
            AdminAccess.builder().adminUsername("root").build().init((AdminAccess.Configuration)TestConfiguration.INSTANCE).render(OsFamily.UNIX);
        }
        finally {
            TestConfiguration.INSTANCE.reset();
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testFamilyRequiredAllowed() throws IOException {
        AdminAccess.standard().render(null);
    }

    public void testWhenUninitializedLazyInitWithDefaultConfiguration() throws IOException {
        AdminAccess access = AdminAccess.standard();
        Assert.assertEquals((String)access.config.getAdminUsername(), null);
        Assert.assertEquals((String)access.config.getAdminPassword(), null);
        Assert.assertEquals((String)access.config.getAdminPublicKey(), null);
        Assert.assertEquals((String)access.config.getAdminPrivateKey(), null);
        Assert.assertEquals((String)access.config.getLoginPassword(), null);
        access.render(OsFamily.UNIX);
        try {
            Assert.assertEquals((String)access.config.getAdminUsername(), (String)System.getProperty("user.name"));
            Assert.assertNotNull((Object)access.config.getAdminPassword());
            Assert.assertNotNull((Object)access.config.getAdminPublicKey());
            Assert.assertNotNull((Object)access.config.getAdminPrivateKey());
            Assert.assertNotNull((Object)access.config.getLoginPassword());
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

