/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.elb;

import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.aws.domain.Region;
import org.jclouds.elb.ELBApiMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;

public class AWSELBProviderMetadata
extends BaseProviderMetadata {
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return (Builder)((Object)Builder.class.cast((Object)AWSELBProviderMetadata.builder().fromProviderMetadata((ProviderMetadata)this)));
    }

    public AWSELBProviderMetadata() {
        super((BaseProviderMetadata.Builder)AWSELBProviderMetadata.builder());
    }

    public AWSELBProviderMetadata(Builder builder) {
        super((BaseProviderMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)Region.regionProperties());
        properties.setProperty("jclouds.region.us-east-1.endpoint", "https://elasticloadbalancing.us-east-1.amazonaws.com");
        properties.setProperty("jclouds.region.us-west-1.endpoint", "https://elasticloadbalancing.us-west-1.amazonaws.com");
        properties.setProperty("jclouds.region.us-west-2.endpoint", "https://elasticloadbalancing.us-west-2.amazonaws.com");
        properties.setProperty("jclouds.region.sa-east-1.endpoint", "https://elasticloadbalancing.sa-east-1.amazonaws.com");
        properties.setProperty("jclouds.region.eu-west-1.endpoint", "https://elasticloadbalancing.eu-west-1.amazonaws.com");
        properties.setProperty("jclouds.region.ap-southeast-1.endpoint", "https://elasticloadbalancing.ap-southeast-1.amazonaws.com");
        properties.setProperty("jclouds.region.ap-southeast-2.endpoint", "https://elasticloadbalancing.ap-southeast-2.amazonaws.com");
        properties.setProperty("jclouds.region.ap-northeast-1.endpoint", "https://elasticloadbalancing.ap-northeast-1.amazonaws.com");
        properties.setProperty("jclouds.aws.zoneclient-endpoint", "https://ec2.us-east-1.amazonaws.com");
        return properties;
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("aws-elb").name("Amazon Elastic Load Balancing").endpoint("https://elasticloadbalancing.us-east-1.amazonaws.com").homepage(URI.create("http://aws.amazon.com/elasticloadbalancing")).console(URI.create("https://console.aws.amazon.com/ec2/home")).linkedServices(new String[]{"aws-ec2", "aws-elb", "aws-cloudwatch", "aws-s3", "aws-simpledb"}).iso3166Codes(new String[]{"US-VA", "US-CA", "BR-SP", "US-OR", "IE", "SG", "AU-NSW", "JP-13"}).apiMetadata((ApiMetadata)new ELBApiMetadata()).defaultProperties(AWSELBProviderMetadata.defaultProperties());
        }

        public Builder fromProviderMetadata(ProviderMetadata in) {
            super.fromProviderMetadata(in);
            return this;
        }
    }
}

