/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.InstanceTemplate;
import org.jclouds.googlecomputeengine.domain.MachineType;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.Zone;
import org.jclouds.http.HttpResponse;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;

public class GoogleComputeEngineServiceAdapter
implements ComputeServiceAdapter<Instance, MachineType, Image, Zone> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final GoogleComputeEngineApi api;
    private final Supplier<String> userProject;
    private final Function<TemplateOptions, ImmutableMap.Builder<String, String>> metatadaFromTemplateOptions;
    private final Predicate<AtomicReference<Operation>> retryOperationDonePredicate;
    private final long operationCompleteCheckInterval;
    private final long operationCompleteCheckTimeout;

    @Inject
    public GoogleComputeEngineServiceAdapter(GoogleComputeEngineApi api, @UserProject Supplier<String> userProject, Function<TemplateOptions, ImmutableMap.Builder<String, String>> metatadaFromTemplateOptions, Predicate<AtomicReference<Operation>> operationDonePredicate, @Named(value="jclouds.google-compute-engine.operation-complete-interval") Long operationCompleteCheckInterval, @Named(value="jclouds.google-compute-engine.operation-complete-timeout") Long operationCompleteCheckTimeout) {
        this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"google compute api");
        this.userProject = (Supplier)Preconditions.checkNotNull(userProject, (Object)"user project name");
        this.metatadaFromTemplateOptions = (Function)Preconditions.checkNotNull(metatadaFromTemplateOptions, (Object)"metadata from template options function");
        this.operationCompleteCheckInterval = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckInterval, (Object)"operation completed check interval");
        this.operationCompleteCheckTimeout = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckTimeout, (Object)"operation completed check timeout");
        this.retryOperationDonePredicate = Predicates2.retry(operationDonePredicate, (long)operationCompleteCheckTimeout, (long)operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Instance> createNodeWithGroupEncodedIntoName(String group, final String name, Template template) {
        Preconditions.checkNotNull((Object)template, (Object)"template");
        GoogleComputeEngineTemplateOptions options = ((GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(template.getOptions()))).clone();
        Preconditions.checkState((boolean)options.getNetwork().isPresent(), (Object)"network was not present in template options");
        Hardware hardware = (Hardware)Preconditions.checkNotNull((Object)template.getHardware(), (Object)"hardware must be set");
        URI machineType = (URI)Preconditions.checkNotNull((Object)hardware.getUri(), (Object)"hardware uri must be set");
        InstanceTemplate instanceTemplate = InstanceTemplate.builder().forMachineType(machineType);
        if (options.isEnableNat()) {
            instanceTemplate.addNetworkInterface((URI)options.getNetwork().get(), Instance.NetworkInterface.AccessConfig.Type.ONE_TO_ONE_NAT);
        } else {
            instanceTemplate.addNetworkInterface((URI)options.getNetwork().get());
        }
        LoginCredentials credentials = this.getFromImageAndOverrideIfRequired(template.getImage(), options);
        ImmutableMap.Builder metadataBuilder = (ImmutableMap.Builder)this.metatadaFromTemplateOptions.apply((Object)options);
        instanceTemplate.metadata((Map<String, String>)metadataBuilder.build());
        instanceTemplate.tags(options.getTags());
        instanceTemplate.serviceAccounts(options.getServiceAccounts());
        instanceTemplate.image((URI)Preconditions.checkNotNull((Object)template.getImage().getUri(), (Object)"image URI is null"));
        Operation operation = this.api.getInstanceApiForProject((String)this.userProject.get()).createInZone(name, instanceTemplate, template.getLocation().getId());
        if (options.shouldBlockUntilRunning()) {
            this.waitOperationDone(operation);
        }
        AtomicReference instance = new AtomicReference();
        Predicates2.retry((Predicate)new Predicate<AtomicReference<Instance>>(){

            public boolean apply(AtomicReference<Instance> input) {
                input.set(GoogleComputeEngineServiceAdapter.this.api.getInstanceApiForProject((String)GoogleComputeEngineServiceAdapter.this.userProject.get()).get(name));
                return input.get() != null;
            }
        }, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply(instance);
        return new ComputeServiceAdapter.NodeAndInitialCredentials(instance.get(), name, credentials);
    }

    public Iterable<MachineType> listHardwareProfiles() {
        return this.api.getMachineTypeApiForProject((String)this.userProject.get()).list().concat();
    }

    public Iterable<Image> listImages() {
        return ImmutableSet.builder().addAll((Iterable)this.api.getImageApiForProject((String)this.userProject.get()).list().concat()).addAll((Iterable)this.api.getImageApiForProject("google").list().concat()).build();
    }

    public Image getImage(String id) {
        return (Image)Objects.firstNonNull((Object)this.api.getImageApiForProject((String)this.userProject.get()).get(id), (Object)this.api.getImageApiForProject("google").get(id));
    }

    public Iterable<Zone> listLocations() {
        return this.api.getZoneApiForProject((String)this.userProject.get()).list().concat();
    }

    public Instance getNode(String name) {
        return this.api.getInstanceApiForProject((String)this.userProject.get()).get(name);
    }

    public Iterable<Instance> listNodes() {
        return this.api.getInstanceApiForProject((String)this.userProject.get()).list().concat();
    }

    public void destroyNode(String name) {
        this.waitOperationDone(this.api.getInstanceApiForProject((String)this.userProject.get()).delete(name));
    }

    public void rebootNode(String name) {
        throw new UnsupportedOperationException("reboot is not supported by GCE");
    }

    public void resumeNode(String name) {
        throw new UnsupportedOperationException("resume is not supported by GCE");
    }

    public void suspendNode(String name) {
        throw new UnsupportedOperationException("suspend is not supported by GCE");
    }

    private LoginCredentials getFromImageAndOverrideIfRequired(org.jclouds.compute.domain.Image image, GoogleComputeEngineTemplateOptions options) {
        LoginCredentials defaultCredentials = image.getDefaultCredentials();
        String[] keys = defaultCredentials.getPrivateKey().split(":");
        String publicKey = keys[0];
        String privateKey = keys[1];
        LoginCredentials.Builder credentialsBuilder = defaultCredentials.toBuilder();
        credentialsBuilder.privateKey(privateKey);
        if (options.getPublicKey() == null) {
            options.authorizePublicKey(publicKey);
        }
        if (options.hasLoginPrivateKeyOption()) {
            credentialsBuilder.privateKey(options.getPrivateKey());
        }
        if (options.getLoginUser() != null) {
            credentialsBuilder.identity(options.getLoginUser());
        }
        if (options.hasLoginPasswordOption()) {
            credentialsBuilder.password(options.getLoginPassword());
        }
        if (options.shouldAuthenticateSudo() != null) {
            credentialsBuilder.authenticateSudo(options.shouldAuthenticateSudo().booleanValue());
        }
        LoginCredentials credentials = credentialsBuilder.build();
        options.overrideLoginCredentials(credentials);
        return credentials;
    }

    private void waitOperationDone(Operation operation) {
        AtomicReference<Operation> operationRef = new AtomicReference<Operation>(operation);
        if (!this.retryOperationDonePredicate.apply(operationRef)) {
            throw new UncheckedTimeoutException("operation did not reach DONE state" + operationRef.get());
        }
        if (operationRef.get().getHttpError().isPresent()) {
            HttpResponse response = (HttpResponse)operationRef.get().getHttpError().get();
            throw new IllegalStateException("operation failed. Http Error Code: " + response.getStatusCode() + " HttpError: " + response.getMessage());
        }
    }
}

